/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.grouping;

import com.dataiku.dip.eda.compute.filtering.AnumFilter;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.filtering.NotFilter;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.GroupingResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class AnumGrouping
extends Grouping {
    public static final String TYPE = "anum";
    public String column;
    @Nullable
    public Integer maxValues;
    @Nullable
    public List<String> excludeValues;
    public boolean groupOthers;

    private AnumGrouping() {
    }

    public AnumGrouping(String column) {
        this(column, 20, false);
    }

    public AnumGrouping(String column, @Nullable Integer maxValues, boolean groupOthers) {
        this(column, maxValues, null, groupOthers);
    }

    public AnumGrouping(String column, @Nullable Integer maxValues, @Nullable List<String> excludeValues, boolean groupOthers) {
        this.column = column;
        this.maxValues = maxValues;
        this.excludeValues = excludeValues;
        this.groupOthers = groupOthers;
    }

    public static class AnumGroupingResult
    extends GroupingResult {
        public String[] values;
        public String column;
        public boolean hasOthers;
        public boolean hasAllValues;

        private AnumGroupingResult() {
        }

        @VisibleForTesting
        public AnumGroupingResult(String column, String[] values, boolean hasOthers, boolean hasAllValues) {
            this.values = values;
            this.column = column;
            this.hasOthers = hasOthers;
            this.hasAllValues = hasAllValues;
        }

        @Override
        public List<Filter> listFilters() {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (String value : this.values) {
                filters.add(new AnumFilter(this.column, (Set<String>)ImmutableSet.of((Object)value)));
            }
            if (this.hasOthers) {
                filters.add(new NotFilter("Others", new AnumFilter(this.column, (Set<String>)ImmutableSet.copyOf((Object[])this.values))));
            }
            return filters;
        }

        @Override
        public int size() {
            return this.values.length + (this.hasOthers ? 1 : 0);
        }
    }
}

