/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.univariate.FitDistribution;
import com.dataiku.dip.eda.compute.computations.univariate.TestDistribution;
import com.dataiku.dip.eda.compute.distributions.Distribution;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.UnivariateCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithConfidenceLevel;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.fragments.NumericalHistogramFragment;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class FitDistributionCard
extends UnivariateCard
implements CardWithConfidenceLevel {
    public static final String TYPE = "fit_distribution";
    public List<RequestedDistribution> distributions;
    public double confidenceLevel;

    public FitDistributionCard(Variable column, List<RequestedDistribution> distributions) {
        this.column = column;
        this.distributions = distributions;
    }

    private FitDistributionCard() {
    }

    @Override
    public void setConfidenceLevel(double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<MultiComputation, MultiComputation.MultiComputationResult>(){

            @Override
            public MultiComputation getComputationPlan() {
                ArrayList<Computation> plan = new ArrayList<Computation>();
                for (RequestedDistribution distribution : FitDistributionCard.this.distributions) {
                    if (distribution.fixedParameters == null) {
                        plan.add(new FitDistribution(FitDistributionCard.this.column.name, distribution.distribution, true));
                        continue;
                    }
                    plan.add(new TestDistribution(FitDistributionCard.this.column.name, distribution.fixedParameters));
                }
                plan.add(NumericalHistogramFragment.getPlan(FitDistributionCard.this.column));
                return new MultiComputation(plan);
            }

            @Override
            protected CardResult buildFromFullyAvailableResult(MultiComputation.MultiComputationResult result) {
                ArrayList<SingleFitResult> distributionResults = new ArrayList<SingleFitResult>();
                for (int i = 0; i < FitDistributionCard.this.distributions.size(); ++i) {
                    RequestedDistribution requestedDistribution = FitDistributionCard.this.distributions.get(i);
                    if (requestedDistribution.fixedParameters == null) {
                        FitDistribution.FitDistributionResult distribFit = result.get(i).as(FitDistribution.FitDistributionResult.class);
                        distributionResults.add(new SingleFitResult(FitDistributionCard.this.distributions.get((int)i).distribution, distribFit.fit, distribFit.test.plot, distribFit.test.test, result.collectWarnings()));
                        continue;
                    }
                    TestDistribution.TestDistributionResult distribTest = result.get(i).as(TestDistribution.TestDistributionResult.class);
                    distributionResults.add(new SingleFitResult(FitDistributionCard.this.distributions.get((int)i).distribution, requestedDistribution.fixedParameters, distribTest.plot, distribTest.test, result.collectWarnings()));
                }
                ComputationResult histogramCompResult = result.get(result.size() - 1);
                NumericalHistogramFragment histogram = NumericalHistogramFragment.buildResult(histogramCompResult);
                return new FitDistributionCardResult(distributionResults, histogram);
            }
        };
    }

    public static class FitDistributionCardResult
    extends CardResult {
        public List<SingleFitResult> distributions;
        public NumericalHistogramFragment histogram;

        public FitDistributionCardResult(List<SingleFitResult> distributions, NumericalHistogramFragment histogram) {
            this.distributions = distributions;
            this.histogram = histogram;
        }

        private FitDistributionCardResult() {
        }
    }

    @UIModel
    public static class SingleFitResult
    extends ImmutableValueObject {
        public Distribution distribution;
        public Distribution.FittedDistribution fit;
        public TestDistribution.PlotData plot;
        public TestDistribution.StatTests test;
        public List<String> warnings;

        public SingleFitResult(Distribution distribution, Distribution.FittedDistribution fit, TestDistribution.PlotData plot, TestDistribution.StatTests test, List<String> warnings) {
            this.distribution = distribution;
            this.fit = fit;
            this.plot = plot;
            this.test = test;
            this.warnings = warnings;
        }

        private SingleFitResult() {
        }
    }

    @UIModel
    public static class RequestedDistribution
    extends ImmutableValueObject {
        public Distribution distribution;
        @Nullable
        public Distribution.FittedDistribution fixedParameters;

        public RequestedDistribution(Distribution distribution, Distribution.FittedDistribution fixedParameters) {
            this.distribution = distribution;
            this.fixedParameters = fixedParameters;
        }

        public RequestedDistribution(Distribution distribution) {
            this.distribution = distribution;
            this.fixedParameters = null;
        }

        private RequestedDistribution() {
        }
    }
}

