/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.univariate.PairwiseLeveneTest;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.stats.LeveneCenter;
import com.dataiku.dip.eda.compute.stats.PValueAdjustmentMethod;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateHistogramCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractNSampTestCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractPairwiseTestCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.RecipeCompatibleCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

public class PairwiseLeveneTestCard
extends AbstractPairwiseTestCard
implements RecipeCompatibleCard {
    public static final String TYPE = "pairwise_levene";
    public LeveneCenter center;
    @Nullable
    public Double proportionToTrim;

    public PairwiseLeveneTestCard(Variable xColumn, Variable yColumn, List<String> yValues, int maxGroups, @Nullable String referenceGroup, PValueAdjustmentMethod adjustmentMethod, LeveneCenter center, @Nullable Double proportionToTrim) {
        this.xColumn = xColumn;
        this.yColumn = yColumn;
        this.yValues = yValues;
        this.maxGroups = maxGroups;
        this.referenceGroup = referenceGroup;
        this.adjustmentMethod = adjustmentMethod;
        this.center = center;
        this.proportionToTrim = proportionToTrim;
    }

    private PairwiseLeveneTestCard() {
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractPairwiseTestCard.AbstractCompiledPairwiseTestCard(){

            @Override
            protected Computation getTestComputation(Grouping grouping) {
                return new PairwiseLeveneTest(PairwiseLeveneTestCard.this.xColumn.name, grouping, PairwiseLeveneTestCard.this.referenceGroup != null, PairwiseLeveneTestCard.this.adjustmentMethod, PairwiseLeveneTestCard.this.center, PairwiseLeveneTestCard.this.proportionToTrim);
            }

            @Override
            protected PairwiseLeveneTestCardResult buildTestCardResult(ComputationResult result, List<String> warnings, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups, BivariateHistogramCard.BivariateHistogramData histogramData) {
                PairwiseLeveneTest.PairwiseLeveneTestResult levene = result.as(PairwiseLeveneTest.PairwiseLeveneTestResult.class);
                ImmutableList allWarnings = ImmutableList.builder().addAll(result.collectWarnings()).addAll(warnings).build();
                return new PairwiseLeveneTestCardResult((List<String>)allWarnings, groups, allGroups, histogramData, levene.pvalues, levene.adjustedPvalues, levene.statistics, levene.centers);
            }
        };
    }

    public static class PairwiseLeveneTestCardResult
    extends AbstractNSampTestCard.AbstractNSampleTestCardResult {
        public double[] pvalues;
        public double[] adjustedPvalues;
        public double[] statistics;
        public double[] centers;

        public PairwiseLeveneTestCardResult(List<String> warnings, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups, BivariateHistogramCard.BivariateHistogramData histogramData, double[] pvalues, double[] adjustedPvalues, double[] statistics, double[] centers) {
            this.warnings = warnings;
            this.groups = groups;
            this.allGroups = allGroups;
            this.histogramData = histogramData;
            this.pvalues = pvalues;
            this.adjustedPvalues = adjustedPvalues;
            this.statistics = statistics;
            this.centers = centers;
        }

        private PairwiseLeveneTestCardResult() {
        }
    }
}

