/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.univariate.PairwiseTTest;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.stats.AlternativeHypothesis;
import com.dataiku.dip.eda.compute.stats.PValueAdjustmentMethod;
import com.dataiku.dip.eda.compute.stats.VarianceAssumption;
import com.dataiku.dip.eda.worksheets.cards.common.Abstract2SampTestCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractNSampTestCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.RecipeCompatibleCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import java.util.List;
import javax.annotation.Nullable;

public class TTest2SampCard
extends Abstract2SampTestCard
implements RecipeCompatibleCard {
    public static final String TYPE = "ttest_2samp";
    public VarianceAssumption varianceAssumption = VarianceAssumption.EQUAL;
    public AlternativeHypothesis alternative = AlternativeHypothesis.TWO_SIDED;

    public TTest2SampCard(Variable xColumn, Variable yColumn, String[] value1, String[] value2, VarianceAssumption varianceAssumption, AlternativeHypothesis alternative) {
        this.xColumn = xColumn;
        this.yColumn = yColumn;
        this.value1 = value1;
        this.value2 = value2;
        this.varianceAssumption = varianceAssumption;
        this.alternative = alternative;
    }

    private TTest2SampCard() {
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new Abstract2SampTestCard.AbstractCompiled2SampTestCard(){

            @Override
            protected Computation getTestComputation() {
                Grouping grouping = this.getGrouping();
                return new PairwiseTTest(TTest2SampCard.this.xColumn.name, grouping, false, TTest2SampCard.this.varianceAssumption, PValueAdjustmentMethod.NONE, TTest2SampCard.this.alternative, TTest2SampCard.this.confidenceLevel);
            }

            @Override
            protected Abstract2SampTestCard.Abstract2SampTestCardResult buildTestCardResult(ComputationResult result, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups) {
                PairwiseTTest.PairwiseTTestResult ttest = result.as(PairwiseTTest.PairwiseTTestResult.class);
                return new TTest2SampCardResult(result.collectWarnings(), groups, allGroups, ttest.statistics[0], ttest.pvalues[0], ttest.meanDiffs[0], ttest.ciLowers[0], ttest.ciUppers[0], ttest.dofs[0]);
            }
        };
    }

    public static class TTest2SampCardResult
    extends Abstract2SampTestCard.Abstract2SampTestCardResult {
        public double statistic;
        public double pvalue;
        public double meanDiff;
        @Nullable
        public Double ciLower;
        @Nullable
        public Double ciUpper;
        public double dof;

        public TTest2SampCardResult(List<String> warnings, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups, double statistic, double pvalue, double meanDiff, @Nullable Double ciLower, @Nullable Double ciUpper, double dof) {
            this.warnings = warnings;
            this.groups = groups;
            this.allGroups = allGroups;
            this.statistic = statistic;
            this.pvalue = pvalue;
            this.meanDiff = meanDiff;
            this.ciLower = ciLower;
            this.ciUpper = ciUpper;
            this.dof = dof;
        }

        private TTest2SampCardResult() {
        }
    }
}

