/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eventserver.dssmodel;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.processors.ConnectionPathTargetProcessorSettings;
import com.dataiku.dip.security.auth.APIAuthUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

public class EventServerSettings {
    public List<ConnectionPathTargetProcessorSettings> targets = new ArrayList<ConnectionPathTargetProcessorSettings>();
    public int queueSize = 5000;
    public boolean requireAuthenticationForEvents;
    public List<EventServerAuthKey> eventsAuthenticationKeys = new ArrayList<EventServerAuthKey>();
    public boolean requireAuthenticationForStats;
    public List<EventServerAuthKey> statsAuthenticationKeys = new ArrayList<EventServerAuthKey>();

    public String checkEventCallAuth(HttpServletRequest req) throws DKUSecurityException {
        if (this.requireAuthenticationForEvents) {
            String apiKey = APIAuthUtils.getKeyStr((HttpServletRequest)req);
            for (EventServerAuthKey possibleKeys : this.eventsAuthenticationKeys) {
                if (!possibleKeys.key.equals(apiKey)) continue;
                return apiKey;
            }
            throw new UnauthorizedException("Invalid authentication: " + apiKey, "invalid-auth");
        }
        return null;
    }

    public void checkStatsCallAuth(HttpServletRequest req) throws DKUSecurityException {
        if (this.requireAuthenticationForStats) {
            String apiKey = APIAuthUtils.getKeyStr((HttpServletRequest)req);
            for (EventServerAuthKey possibleKeys : this.statsAuthenticationKeys) {
                if (!possibleKeys.key.equals(apiKey)) continue;
                return;
            }
            throw new UnauthorizedException("Invalid authentication", "invalid-auth");
        }
    }

    public List<ConnectionPathTargetProcessorSettings> getTargets() {
        return this.targets;
    }

    public static class EventServerAuthKey {
        public String key;

        public EventServerAuthKey() {
        }

        public EventServerAuthKey(String key) {
            this.key = key;
        }
    }
}

