/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomJavaElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.export.CustomExportersRegistry;
import com.dataiku.dip.export.CustomJavaExporter;
import com.dataiku.dip.export.CustomJavaExporterDesc;
import com.dataiku.dip.export.ExportOption;
import com.dataiku.dip.export.LoadedJavaExporter;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomJavaExportersService
extends CustomJavaElementService<CustomJavaExporterDesc, LoadedJavaExporter> {
    @Override
    public String getFolderName() {
        return "java-exporters";
    }

    @Override
    public String getPrefix() {
        return "jexporter";
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "jexporter_" + pluginId + "_" + elementId;
    }

    @Override
    public Class<CustomJavaExporterDesc> getDescClass() {
        return CustomJavaExporterDesc.class;
    }

    @Override
    public Class<LoadedJavaExporter> getLoadedDescClass() {
        return LoadedJavaExporter.class;
    }

    @Override
    protected void removeElement(LoadedJavaExporter desc) {
        CustomExportersRegistry.deregister(desc.exporterType);
    }

    @Override
    protected LoadedJavaExporter load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedJavaExporter loaded = new LoadedJavaExporter(elementType, pluginId, elementId, (CustomJavaExporterDesc)JSON.parseFile((File)file, CustomJavaExporterDesc.class));
        CustomExportersRegistry.register(new CustomJavaExporter(loaded, this));
        return loaded;
    }

    @Override
    protected String getCodeExtension(LoadedJavaExporter desc) {
        return ".java";
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomJavaExporterDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomJavaExportersService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                if (StringUtils.isBlank((String)desc.exporterClass)) {
                    this.withFatal("Java plugin exporters require a \"exporterClass\" field.");
                }
                if (desc.exportOptions != null) {
                    for (ExportOption o : desc.exportOptions) {
                        if (o == null) {
                            this.withWarning("Null export option. Check there is no trailing comma.");
                            continue;
                        }
                        if (!StringUtils.isBlank((String)o.label)) continue;
                        this.withFatal("Export option has no id.");
                    }
                }
                return this.messages;
            }
        }.validate();
    }
}

