/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.input;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.futures.FuturePayload;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;

public class ExportUIDataInput
implements ExportInput {
    private ExportableUIData data;
    private ColumnFactory scf;

    public ExportUIDataInput(ExportableUIData data) {
        this.data = data;
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, StreamableDatasetSelection selection, ColumnFactory cf) {
        this.scf = cf;
    }

    @Override
    public long getInputSize() {
        return this.data.data.size();
    }

    @Override
    public ExportInput.InputDescription describe() {
        ExportInput.InputDescription id = new ExportInput.InputDescription();
        id.name = this.data.name;
        id.description = this.data.description;
        return id;
    }

    @Override
    public Schema getSchema() throws Exception {
        Schema s = new Schema();
        s.columns = this.data.columns;
        return s;
    }

    @Override
    public void stream(ProcessorOutput output) throws Exception {
        StreamRowFactory srf = new StreamRowFactory();
        ArrayList<Column> columns = new ArrayList<Column>();
        for (SchemaColumn col : this.data.columns) {
            columns.add(this.scf.column(col.getName()));
        }
        for (JsonArray row : this.data.data) {
            Row r = srf.row();
            int i = 0;
            for (JsonElement elt : row) {
                if (i < columns.size() && elt != null && !elt.isJsonNull()) {
                    r.put((Column)columns.get(i), elt.getAsString());
                }
                ++i;
            }
            output.emitRow(r);
        }
        output.lastRowEmitted();
    }

    @Override
    public void close() {
    }

    @Override
    public FuturePayload.FuturePayloadTarget getSource() {
        return new FuturePayload.FuturePayloadTarget("ui", "UIDATA");
    }

    public static class ExportableUIData {
        public String name;
        public String description;
        public List<SchemaColumn> columns = new ArrayList<SchemaColumn>();
        public List<JsonArray> data = new ArrayList<JsonArray>();
    }
}

