/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.input;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamRow;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.input.AbstractSampledExport;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.export.input.Sampler;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.input.formats.csv.RFC4180CSVParser;
import com.dataiku.dip.input.stream.InputStreamLineReader;
import com.dataiku.dip.input.stream.LineReader;
import com.dataiku.dip.server.services.ITaggingService;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class JupyterExportStream
extends AbstractSampledExport {
    private RFC4180CSVParser csvParser;
    private Schema schema;
    private ArrayList<Column> columns = new ArrayList();
    private ArrayList<String> cellBuffer = new ArrayList();
    private DataInputStream is;
    private int inputSize = -1;
    private ExportInput.InputDescription description = new ExportInput.InputDescription();
    private static final Logger logger = Logger.getLogger(JupyterExportStream.class);

    public JupyterExportStream(InputStream is) {
        this.is = new DataInputStream(is);
        this.description.name = "Pandas dataframe";
        this.description.description = "";
    }

    private String readString() throws IOException {
        int len = this.readInt();
        byte[] bytes = new byte[len];
        this.is.readFully(bytes);
        String s = new String(bytes, "utf8");
        return s;
    }

    private int readInt() throws IOException {
        return this.is.readInt();
    }

    @Override
    public Schema getSchema() throws Exception {
        return this.schema;
    }

    @Override
    public void close() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                logger.error((Object)"Unable to close input stream", (Throwable)e);
            }
            this.is = null;
        }
    }

    @Override
    public long getInputSize() {
        return this.inputSize;
    }

    @Override
    public ExportInput.InputDescription describe() {
        return this.description;
    }

    @Override
    protected void initializeImpl(ExportService.LocalExportJob job, StreamableDatasetSelection selection, ColumnFactory cf) throws Exception {
        this.description.status = "Initializing...";
        int nbCol = this.readInt();
        this.schema = new Schema();
        for (int i = 0; i < nbCol; ++i) {
            String name = this.readString();
            String type = this.readString();
            this.schema.addColumn(name, Type.forName((String)type));
            this.columns.add(cf.column(name));
        }
        this.inputSize = this.readInt();
        this.csvParser = new RFC4180CSVParser((LineReader)new InputStreamLineReader((InputStream)this.is, "utf8"), ',');
    }

    @Override
    protected void streamImpl(Sampler output) throws Exception {
        this.description.status = "Streaming dataframe from Jupyter...";
        while (this.csvParser.next(this.cellBuffer)) {
            if (this.cellBuffer.size() != this.columns.size()) {
                throw new Exception("Invalid CSV schema");
            }
            StreamRow row = new StreamRow();
            for (int i = 0; i < this.columns.size(); ++i) {
                row.put(this.columns.get(i), this.cellBuffer.get(i));
            }
            output.emitRow((Row)row);
        }
        output.lastRowEmitted();
    }

    @Override
    public FuturePayload.FuturePayloadTarget getSource() {
        return new FuturePayload.FuturePayloadTarget("pandas", ITaggingService.TaggableType.JUPYTER_NOTEBOOK.name());
    }
}

