/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.exposition.AbstractIngressExposition;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionDesc;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NginxIngressExposition {
    public static final ExpositionMeta META = new ExpositionMeta(){

        @Override
        public String getType() {
            return "nginx_ingress";
        }

        @Override
        public Class<? extends ExpositionParams> getParamsClass() {
            return NginxIngressExpositionParams.class;
        }

        @Override
        public ExpositionDesc getDesc(ExpositionMeta.ExpositionUsageContext usageContext) {
            ParamDesc affinity = new ParamDesc();
            affinity.type = ParamDesc.Type.SELECT;
            affinity.name = "affinity";
            affinity.label = "Affinity";
            affinity.defaultValue = "NONE";
            affinity.selectChoices = Lists.newArrayList();
            affinity.selectChoices.add(new ParamDesc.SelectChoice().withLabel("None").withValue(Affinity.NONE.name()));
            affinity.selectChoices.add(new ParamDesc.SelectChoice().withLabel("Generated cookie").withValue(Affinity.COOKIE.name()));
            ParamDesc servicePath = new ParamDesc();
            servicePath.type = ParamDesc.Type.STRING;
            servicePath.name = "servicePath";
            servicePath.label = "Service path";
            servicePath.description = "URL subpath for the service, to discriminate between services exposed on the ingress. You can use the following variables in the path \"__published_service_id__\" and \"__deployment_id__\" which will get replaced with the actual values";
            ParamDesc rewriteToRoot = new ParamDesc();
            rewriteToRoot.type = ParamDesc.Type.BOOLEAN;
            rewriteToRoot.name = "rewriteToRoot";
            rewriteToRoot.label = "Rewrite path";
            rewriteToRoot.description = "Rewrite the path of the URL to remove the service path. If service path is empty, uses a random one.";
            ParamDesc addApiPath = new ParamDesc();
            addApiPath.type = ParamDesc.Type.BOOLEAN;
            addApiPath.name = "addApiPath";
            addApiPath.label = "Add API path";
            addApiPath.description = "Add the public API path (/public/api/v1) to the resulting rewritten URL. If activated, you should also omit it from the service path field above.";
            addApiPath.visibilityCondition = "model.rewriteToRoot";
            ParamDesc tlsTermination = new ParamDesc();
            tlsTermination.type = ParamDesc.Type.BOOLEAN;
            tlsTermination.name = "tlsTermination";
            tlsTermination.label = "TLS termination";
            ParamDesc addRulesForTLSHosts = new ParamDesc();
            addRulesForTLSHosts.type = ParamDesc.Type.BOOLEAN;
            addRulesForTLSHosts.name = "addRulesForTLSHosts";
            addRulesForTLSHosts.label = "Add TLS hosts";
            addRulesForTLSHosts.defaultValue = true;
            addRulesForTLSHosts.description = "Add the hosts of the TLS certificates as rules in the ingress";
            addRulesForTLSHosts.visibilityCondition = "model.tlsTermination";
            ParamDesc tlsSecretName = new ParamDesc();
            tlsSecretName.type = ParamDesc.Type.STRING;
            tlsSecretName.name = "secretName";
            tlsSecretName.label = "Certificate secret";
            tlsSecretName.description = "Name of a certificate secret in the cluster";
            ParamDesc tlsKeyPath = new ParamDesc();
            tlsKeyPath.type = ParamDesc.Type.STRING;
            tlsKeyPath.name = "keyPath";
            tlsKeyPath.label = "Certificate key path";
            tlsKeyPath.description = "Path to a key on the server filesystem";
            ParamDesc tlsCrtPath = new ParamDesc();
            tlsCrtPath.type = ParamDesc.Type.STRING;
            tlsCrtPath.name = "crtPath";
            tlsCrtPath.label = "Certificate cert path";
            tlsCrtPath.description = "Path to a cert on the server filesystem.";
            ParamDesc tlsHosts = new ParamDesc();
            tlsHosts.type = ParamDesc.Type.STRINGS;
            tlsHosts.name = "hosts";
            tlsHosts.label = "Domains";
            tlsHosts.description = "Terminate TLS using the key/cert pair on this list of domains";
            ParamDesc tlsCertHosts = new ParamDesc();
            tlsCertHosts.type = ParamDesc.Type.OBJECT_LIST;
            tlsCertHosts.name = "tlsCertHosts";
            tlsCertHosts.label = "Certificates";
            tlsCertHosts.visibilityCondition = "model.tlsTermination";
            tlsCertHosts.subParams = Lists.newArrayList((Object[])new ParamDesc[]{tlsSecretName, tlsKeyPath, tlsCrtPath, tlsHosts});
            ParamDesc port = AbstractIngressExposition.getPortParamDesc();
            ParamDesc portName = AbstractIngressExposition.getPortNameParamDesc();
            ParamDesc scheme = AbstractIngressExposition.getSchemeParamDesc();
            ParamDesc forcedUrl = AbstractIngressExposition.getForcedUrlParamDesc();
            ParamDesc extraHosts = AbstractIngressExposition.getExtraHostsParamDesc();
            ParamDesc hostForDSS = AbstractIngressExposition.getHostForDSS();
            ExpositionDesc desc = AbstractIngressExposition.getDesc();
            return desc.withType(this.getType()).withMeta(new DkuComponentMetadata("Ingress (Nginx)", "Ingress on a NodePort service (Nginx)", null, null)).withParam(1.getUseIngressClassNameParamDesc()).withParam(affinity).withParam(1.getUseClusterIPServiceParamDesc()).withParam(servicePath).withParam(rewriteToRoot).withParam(addApiPath).withParam(port).withParam(portName).withParam(scheme).withParam(forcedUrl).withParam(extraHosts).withParam(hostForDSS).withParam(tlsTermination).withParam(addRulesForTLSHosts).withParam(tlsCertHosts);
        }

        @Override
        public ExpositionHandler buildHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, Exposition exposition, ExposedEndpointConsumer endpointConsumer) {
            NginxIngressExpositionParams params = exposition.getParamsAs(NginxIngressExpositionParams.class);
            return new NginxIngressExpositionHandler(authCtx, projectKey, containerConfig, params, endpointConsumer);
        }

        @Override
        public long getMaxStartWait(AuthCtx authCtx) {
            return 120000L;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig containerConfig) {
            return containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES && "true".equalsIgnoreCase(containerConfig.getProperty("nginx-ingress.controller", "false"));
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig.Container containerType) {
            return containerType == ContainerExecRuntimeConfig.Container.KUBERNETES;
        }

        @Override
        public boolean handles(Exposables.ExposableKind kind) {
            return kind == Exposables.ExposableKind.WEBAPP || kind == Exposables.ExposableKind.API_DEPLOYER;
        }

        @Override
        public void expandParametersInPlace(VariablesContext vc, Exposition exposition) {
            NginxIngressExpositionParams params = exposition.getParamsAs(NginxIngressExpositionParams.class);
            params.expandParametersInPlace(vc);
            if (StringUtils.isNotBlank((String)params.servicePath)) {
                params.servicePath = vc.expandAllowUnresolved(params.servicePath);
            }
        }

        public static ParamDesc getUseIngressClassNameParamDesc() {
            ParamDesc ingressClassName = new ParamDesc();
            ingressClassName.type = ParamDesc.Type.BOOLEAN;
            ingressClassName.name = "useIngressClassName";
            ingressClassName.label = "Use ingress class name";
            ingressClassName.description = "Enable this option to select the nginx ingress using \"ingressClassName: nginx\" rather than with the kubernetes.io/ingress.class annotation";
            return ingressClassName;
        }

        public static ParamDesc getUseClusterIPServiceParamDesc() {
            ParamDesc desc = new ParamDesc();
            desc.type = ParamDesc.Type.BOOLEAN;
            desc.name = "useClusterIPService";
            desc.label = "Use Cluster IP service type";
            desc.description = "Enable this option to use the \"Cluster IP\" rather than the \"Node Port\" service type";
            return desc;
        }
    };
    private static Logger logger = Logger.getLogger((String)"dip.webapp.expose.nginx");

    private static class NginxIngressExpositionHandler
    extends AbstractIngressExposition.AbstractIngressExpositionHandler<NginxIngressExpositionParams> {
        NginxIngressExpositionHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, NginxIngressExpositionParams params, ExposedEndpointConsumer endpointConsumer) {
            super(authCtx, projectKey, containerConfig, params, endpointConsumer);
        }

        @Override
        protected String expositionType() {
            return META.getType();
        }

        @Override
        protected List<String> getExtra(Map<String, String> serviceAnnotations, Map<String, String> ingressAnnotations) throws IOException {
            if (!((NginxIngressExpositionParams)this.params).useIngressClassName && !ingressAnnotations.containsKey("kubernetes.io/ingress.class")) {
                ingressAnnotations.put("kubernetes.io/ingress.class", "nginx");
            }
            if (((NginxIngressExpositionParams)this.params).affinity != Affinity.NONE) {
                ingressAnnotations.put("nginx.ingress.kubernetes.io/affinity", "cookie");
            }
            if (((NginxIngressExpositionParams)this.params).rewriteToRoot) {
                String pathPrefix = ((NginxIngressExpositionParams)this.params).addApiPath ? "/public/api/v1" : "";
                ingressAnnotations.put("nginx.ingress.kubernetes.io/rewrite-target", pathPrefix + "/$2");
            }
            return null;
        }

        @Override
        protected String getServiceType() {
            if (((NginxIngressExpositionParams)this.params).useClusterIPService) {
                return "ClusterIP";
            }
            return super.getServiceType();
        }

        @Override
        protected String getIngressClassNameSpec() {
            if (((NginxIngressExpositionParams)this.params).useIngressClassName) {
                return "ingressClassName: nginx";
            }
            return null;
        }

        @Override
        @Nullable
        protected String getPortName() {
            return ((NginxIngressExpositionParams)this.params).portName;
        }

        @Override
        protected String getServicePath() {
            String servicePath = this.getPublicServicePath();
            if (servicePath.startsWith("/")) {
                servicePath = servicePath.substring(1);
            }
            if (servicePath.endsWith("/")) {
                servicePath = servicePath.substring(0, servicePath.length() - 1);
            }
            if (((NginxIngressExpositionParams)this.params).rewriteToRoot) {
                return "/" + servicePath + "(/|$)(.*)";
            }
            return "/" + servicePath + (servicePath.isEmpty() ? "" : "/");
        }

        @Override
        protected String getPublicServicePath() {
            String servicePath = StringUtils.defaultIfBlank((String)((NginxIngressExpositionParams)this.params).servicePath, (String)(((NginxIngressExpositionParams)this.params).rewriteToRoot ? this.executionId : ""));
            servicePath = servicePath.replace("__published_service_id__", StringUtils.defaultIfBlank((String)this.publishedServiceId, (String)"")).replace("__deployment_id__", StringUtils.defaultIfBlank((String)this.executionId, (String)""));
            return servicePath;
        }

        @Override
        protected List<String> expandRuleForHosts() {
            List<String> hosts = super.expandRuleForHosts();
            if (((NginxIngressExpositionParams)this.params).tlsTermination && ((NginxIngressExpositionParams)this.params).addRulesForTLSHosts) {
                List tlsHosts = ((NginxIngressExpositionParams)this.params).tlsCertHosts.stream().flatMap(h -> h.hosts.stream()).collect(Collectors.toList());
                hosts.addAll(tlsHosts);
            }
            return hosts;
        }

        @Override
        protected List<String> getIngressTLS(List<KubernetesExecUtils.IngressTLS> tls) throws IOException {
            ArrayList files = Lists.newArrayList();
            int i = 0;
            for (AbstractIngressExposition.TLSCertHost certHost : ((NginxIngressExpositionParams)this.params).tlsCertHosts) {
                Object tlsSecretName;
                if (certHost.hosts.isEmpty()) {
                    throw new IllegalArgumentException("A list of domains is needed for TLS termination");
                }
                if (StringUtils.isBlank((String)certHost.secretName)) {
                    if (StringUtils.isBlank((String)certHost.crtPath)) {
                        throw new IllegalArgumentException("Cert path not defined");
                    }
                    if (!new File(certHost.crtPath).exists()) {
                        throw new IllegalArgumentException("No file exists at the defined cert path");
                    }
                    if (StringUtils.isBlank((String)certHost.keyPath)) {
                        throw new IllegalArgumentException("Key path not defined");
                    }
                    if (!new File(certHost.keyPath).exists()) {
                        throw new IllegalArgumentException("No file exists at the defined key path");
                    }
                    tlsSecretName = "tls-ingress-" + i + "-" + this.executionId;
                    File secretFile = new File(this.tmpDir, "secret_tls_" + i + "_" + this.executionId + ".yaml");
                    String secretDesc = KubernetesExecUtils.getTlsSecretConf((String)tlsSecretName, certHost.keyPath, certHost.crtPath);
                    logger.info((Object)("secret_" + i + "=\n" + secretDesc));
                    DKUFileUtils.writeFileUTF8((File)secretFile, (String)secretDesc);
                    files.add("-f");
                    files.add(secretFile.getAbsolutePath());
                } else {
                    tlsSecretName = certHost.secretName;
                }
                tls.add(new KubernetesExecUtils.IngressTLS((String)tlsSecretName, certHost.hosts));
                ++i;
            }
            return files;
        }

        @Override
        protected boolean shouldAddPublicApiPath() {
            return !((NginxIngressExpositionParams)this.params).addApiPath;
        }
    }

    public static class NginxIngressExpositionParams
    extends AbstractIngressExposition.AbstractIngressExpositionParams {
        public Affinity affinity = Affinity.NONE;
        public String servicePath = null;
        public boolean addRulesForTLSHosts = false;
        public boolean rewriteToRoot = true;
        public boolean addApiPath = false;
        public boolean useIngressClassName = false;
        public boolean useClusterIPService = false;
        @Nullable
        public String portName = null;
    }

    public static enum Affinity {
        NONE,
        COOKIE;

    }
}

