/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.excel;

import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.ColoringDefinition;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.formats.TableColoringHelper;
import com.dataiku.dip.formats.excel.ExcelFormatExtractor;
import com.dataiku.dip.input.TableColoring;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.server.TableColoringService;
import com.dataiku.dip.util.PoiUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelibpoi.org.apache.commons.compress.archivers.zip.Zip64Mode;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.util.HSSFColor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.EncryptionInfo;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.EncryptionMode;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.Encryptor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.SpreadsheetVersion;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Cell;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.FillPatternType;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Font;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.HorizontalAlignment;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Row;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.streaming.SXSSFRow;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.streaming.SXSSFSheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.streaming.SXSSFWorkbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.IndexedColorMap;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFCellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFColor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFFont;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleMath;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

public class ExcelOutputFormatter
implements OutputFormatter {
    private static final int MAX_ROWS = SpreadsheetVersion.EXCEL2007.getMaxRows();
    private static final int MAX_CELL_TEXT_LENGTH = SpreadsheetVersion.EXCEL2007.getMaxTextLength();
    private static final ReadableInstant JAN_1_1900 = new DateTime(1900, 1, 1, 0, 0, DateTimeZone.UTC);
    private final boolean useSharedStringsTable = DKUApp.getProperty((String)"dku.excel.exporter.useSharedStringTable", (boolean)true);
    private final ExcelFormatExtractor.RowOverflowStrategy rowOverflowStrategy;
    private final ExcelFormatExtractor.CellOverflowStrategy cellOverflowStrategy;
    private final ExcelFormatExtractor.InvalidCellStrategy invalidCellStrategy;
    private final String outputSheetName;
    private final SXSSFWorkbook wb;
    private final String password;
    private SXSSFSheet sh;
    private final List<HeaderColumn> headerColumns = new ArrayList<HeaderColumn>();
    private int rownum;
    private Schema outputSchema;
    private TableColoring coloring;
    private final DKUFormulaUtils dkuFormulaUtils = new DKUFormulaUtils();
    private final Map<CellStyleSpec, XSSFCellStyle> cellStyles = new HashMap<CellStyleSpec, XSSFCellStyle>();
    protected WarningsContext warningsContext = new WarningsContext();
    private final TableColoringHelper.ColorFormatFactory<XSSFColor> colorFormatFactory = ColorFormat::new;
    private final Map<String, ColoringDefinition.ColoringGroup> columnNameToColoringGroups = new HashMap<String, ColoringDefinition.ColoringGroup>();
    private final transient TableColoringService coloringService;
    private MemTable table;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.output.excel");

    public ExcelOutputFormatter() {
        this(ExcelFormatExtractor.RowOverflowStrategy.ERROR, ExcelFormatExtractor.CellOverflowStrategy.ERROR, ExcelFormatExtractor.InvalidCellStrategy.ERROR);
    }

    public ExcelOutputFormatter(@Nullable String outputSheetName, @Nullable String password) {
        this(ExcelFormatExtractor.RowOverflowStrategy.ERROR, ExcelFormatExtractor.CellOverflowStrategy.ERROR, ExcelFormatExtractor.InvalidCellStrategy.ERROR, outputSheetName, password);
    }

    public ExcelOutputFormatter(ExcelFormatExtractor.RowOverflowStrategy rowOverflowStrategy, ExcelFormatExtractor.CellOverflowStrategy cellOverflowStrategy, ExcelFormatExtractor.InvalidCellStrategy invalidCellStrategy) {
        this(rowOverflowStrategy, cellOverflowStrategy, invalidCellStrategy, null, null);
    }

    public ExcelOutputFormatter(ExcelFormatExtractor.RowOverflowStrategy rowOverflowStrategy, ExcelFormatExtractor.CellOverflowStrategy cellOverflowStrategy, ExcelFormatExtractor.InvalidCellStrategy invalidCellStrategy, @Nullable String outputSheetName, @Nullable String password) {
        Preconditions.checkState((boolean)PoiUtils.isInitialized(), (Object)"POI not initialized");
        this.wb = new SXSSFWorkbook(null, 100, true, this.useSharedStringsTable);
        this.coloringService = (TableColoringService)SpringUtils.getBean(TableColoringService.class);
        this.rowOverflowStrategy = rowOverflowStrategy != null ? rowOverflowStrategy : ExcelFormatExtractor.RowOverflowStrategy.NEW_SHEET;
        this.cellOverflowStrategy = cellOverflowStrategy != null ? cellOverflowStrategy : ExcelFormatExtractor.CellOverflowStrategy.ERROR;
        this.invalidCellStrategy = invalidCellStrategy != null ? invalidCellStrategy : ExcelFormatExtractor.InvalidCellStrategy.ERROR;
        this.outputSheetName = outputSheetName;
        this.password = password;
        this.wb.setZip64Mode(Zip64Mode.AsNeeded);
    }

    public void setOutputSchema(Schema schema) {
        this.outputSchema = schema;
    }

    public void setColoring(TableColoring coloring) {
        this.coloring = coloring;
    }

    public void setMemTable(Object table) {
        if (table instanceof MemTable) {
            this.table = (MemTable)table;
        }
    }

    public void header(ColumnFactory cf, OutputStream os) throws IOException {
        if (this.outputSchema == null) {
            for (Column column : cf.columns()) {
                this.headerColumns.add(new HeaderColumn(column, false, false, false));
            }
        } else {
            for (SchemaColumn schemaColumn : this.outputSchema.getColumns()) {
                String name = schemaColumn.getName();
                Type columnType = schemaColumn.getType();
                this.headerColumns.add(new HeaderColumn(cf.column(name), columnType.isNumeric(), columnType.isTemporal(), columnType == Type.DATEONLY));
            }
        }
        if (this.coloring != null && !this.coloring.coloringGroups.isEmpty()) {
            for (HeaderColumn headerColumn : this.headerColumns) {
                this.columnNameToColoringGroups.put(headerColumn.column.getName(), ColoringDefinition.findAppliedColoringGroup((List)this.coloring.coloringGroups, (String)headerColumn.column.getName()));
            }
        }
        logger.info((Object)"Starting Excel write");
        this.initializeSheet();
        logger.info((Object)("Excel writer initialized with " + this.headerColumns.size() + " columns"));
    }

    public void format(com.dataiku.dip.datalayer.Row row, ColumnFactory cf, OutputStream os) throws IOException {
        HeaderColumn c2;
        int colIndex;
        Row r = this.newRow();
        if (r == null) {
            return;
        }
        HashMap<Integer, String> overflowValues = new HashMap<Integer, String>();
        ColorFormat colorFormat = null;
        if (this.coloring != null && this.coloring.scheme == ColoringDefinition.TableColoringScheme.SINGLE_COLUMN_RULES) {
            colorFormat = this.computeCellColorFormat(row, this.coloring.singleColumn, null, cf);
        }
        HashMap<ColoringDefinition.ColoringGroup, ColorFormat> cachedBasedOnAnotherColumnColorFormats = new HashMap<ColoringDefinition.ColoringGroup, ColorFormat>();
        for (colIndex = 0; colIndex < this.headerColumns.size(); ++colIndex) {
            c2 = this.headerColumns.get(colIndex);
            String value = row.get(c2.column);
            if (this.coloring != null) {
                ColoringDefinition.ColoringGroup coloringGroup;
                if (this.coloring.scheme == ColoringDefinition.TableColoringScheme.INDIVIDUAL_COLUMNS_RULES) {
                    colorFormat = this.computeCellColorFormat(row, c2.column.getName(), value, cf);
                } else if (this.coloring.scheme == ColoringDefinition.TableColoringScheme.COLORING_GROUPS && (coloringGroup = this.columnNameToColoringGroups.get(c2.column.getName())) != null && (coloringGroup.scheme == ColoringDefinition.ColoringGroupScheme.RULES || coloringGroup.scheme == ColoringDefinition.ColoringGroupScheme.COLOR_SCALE)) {
                    if (coloringGroup.isBasedOnTargetedColumn(c2.column.getName())) {
                        if (cachedBasedOnAnotherColumnColorFormats.containsKey(coloringGroup)) {
                            colorFormat = (ColorFormat)cachedBasedOnAnotherColumnColorFormats.get(coloringGroup);
                        } else {
                            colorFormat = this.computeCellColorFormat(row, c2.column.getName(), value, cf, coloringGroup);
                            if (coloringGroup.scope == ColoringDefinition.ColoringGroupScope.ALL_COLUMNS_BASED_ON_ANOTHER_COLUMN) {
                                cachedBasedOnAnotherColumnColorFormats.put(coloringGroup, colorFormat);
                            }
                        }
                    } else if (coloringGroup.isBasedOnAnotherColumn(c2.column.getName())) {
                        if (cachedBasedOnAnotherColumnColorFormats.containsKey(coloringGroup)) {
                            colorFormat = (ColorFormat)cachedBasedOnAnotherColumnColorFormats.get(coloringGroup);
                        } else {
                            colorFormat = this.computeCellColorFormat(row, coloringGroup.basedOnColumnName, row.get(cf.getColumn(coloringGroup.basedOnColumnName)), cf, coloringGroup);
                            cachedBasedOnAnotherColumnColorFormats.put(coloringGroup, colorFormat);
                        }
                    }
                }
            }
            if (value != null && !value.isEmpty()) {
                Cell cell = r.createCell(colIndex);
                if (value.length() > MAX_CELL_TEXT_LENGTH) {
                    if (this.cellOverflowStrategy == ExcelFormatExtractor.CellOverflowStrategy.NEW_ROW) {
                        overflowValues.put(colIndex, value.substring(MAX_CELL_TEXT_LENGTH));
                        value = value.substring(0, MAX_CELL_TEXT_LENGTH);
                    } else if (this.cellOverflowStrategy == ExcelFormatExtractor.CellOverflowStrategy.TRIM) {
                        value = value.substring(0, MAX_CELL_TEXT_LENGTH);
                    } else {
                        String errorMsg = String.format("Excel files cannot contain cells with more than %d characters but this dataset contains a %d characters value. Select a different \"Cell overflow strategy\" to export this dataset as an Excel file", MAX_CELL_TEXT_LENGTH, value.length());
                        throw new ApplicativeException("Excel file format limitation", errorMsg);
                    }
                }
                try {
                    if (c2.temporal) {
                        this.setCellValueAsDate(cell, value, colorFormat, c2.dateOnly);
                    } else if (c2.numeric && NumberUtils.isNumber((String)value)) {
                        this.setCellValueAsDouble(cell, value, colorFormat);
                    } else {
                        cell.setCellValue(value);
                        this.setCellStyle(cell, colorFormat);
                    }
                }
                catch (Exception e) {
                    if (this.invalidCellStrategy == ExcelFormatExtractor.InvalidCellStrategy.IGNORE) {
                        logger.warn((Object)("Could not export value " + value + ". Cell will be empty"), (Throwable)e);
                    }
                    String errorMsg = "This dataset contains a value that cannot be written as an Excel cell: " + value + " Select a different \"Invalid cell strategy\" to export this dataset as an Excel file";
                    throw new ApplicativeException("Invalid Excel cell", errorMsg);
                }
                c2.maxChars = Math.max(c2.maxChars, value.length());
                c2.totalChars += value.length();
            } else if (colorFormat != null && colorFormat.backgroundColor != null && ((XSSFColor)colorFormat.backgroundColor).getRGB() != null) {
                this.setCellStyle(r.createCell(colIndex), colorFormat);
            }
            if (this.coloring == null || this.coloring.scheme != ColoringDefinition.TableColoringScheme.COLORING_GROUPS) continue;
            colorFormat = null;
        }
        if (this.rownum % 5000 == 0) {
            logger.info((Object)("Written " + this.rownum + " lines"));
        }
        while (!overflowValues.isEmpty()) {
            r = this.newRow();
            if (r == null) {
                return;
            }
            for (colIndex = 0; colIndex < this.headerColumns.size(); ++colIndex) {
                c2 = this.headerColumns.get(colIndex);
                Cell cell = r.createCell(colIndex);
                String value = (String)overflowValues.remove(colIndex);
                if (value == null || value.isEmpty()) continue;
                if (value.length() > MAX_CELL_TEXT_LENGTH) {
                    String strippedValue = value.substring(0, MAX_CELL_TEXT_LENGTH);
                    String overflowValue = value.substring(MAX_CELL_TEXT_LENGTH);
                    overflowValues.put(colIndex, overflowValue);
                    value = strippedValue;
                }
                cell.setCellValue(value);
                c2.maxChars = Math.max(c2.maxChars, value.length());
                c2.totalChars += value.length();
            }
            if (this.rownum % 5000 != 0) continue;
            logger.info((Object)("Written " + this.rownum + " lines"));
        }
    }

    private void initializeSheet() {
        this.rownum = 0;
        this.sh = this.wb.createSheet(this.computeSheetName(1 + this.wb.getNumberOfSheets()));
        this.sh.setDisplayZeros(true);
        Font font = this.wb.createFont();
        font.setBold(true);
        font.setColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        XSSFCellStyle columnHeaderStyle = (XSSFCellStyle)this.wb.createCellStyle();
        columnHeaderStyle.setFont(font);
        columnHeaderStyle.setAlignment(HorizontalAlignment.CENTER);
        columnHeaderStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        columnHeaderStyle.setFillForegroundColor(new XSSFColor(new Color(42, 177, 172), (IndexedColorMap)new DefaultIndexedColorMap()));
        Row r = this.newRow();
        if (r != null) {
            int colnum = 0;
            for (HeaderColumn c2 : this.headerColumns) {
                Cell cell = r.createCell(colnum);
                cell.setCellValue(c2.column.getName());
                cell.setCellStyle((CellStyle)columnHeaderStyle);
                c2.totalChars = c2.maxChars = c2.column.getName().length();
                ++colnum;
            }
        }
    }

    @NotNull
    private String computeSheetName(int sheetIndex) {
        if (StringUtils.isNotBlank((String)this.outputSheetName)) {
            return sheetIndex == 1 ? this.outputSheetName : this.outputSheetName + sheetIndex;
        }
        return "Sheet" + sheetIndex;
    }

    private Row newRow() {
        if (this.rownum >= MAX_ROWS) {
            switch (this.rowOverflowStrategy) {
                case TRIM: {
                    return null;
                }
                case NEW_SHEET: {
                    logger.warn((Object)("Written " + this.rownum + " lines which is above the limit for an Excel sheet. Creating a new sheet."));
                    this.initializeSheet();
                    break;
                }
                default: {
                    String errorMsg = String.format("Excel files cannot contain more than %d rows per sheet but this dataset export has more rows than this limit. Select a different \"Row overflow strategy\" to export this dataset as an Excel file.", MAX_ROWS);
                    throw new ApplicativeException("Excel file format limitation", errorMsg);
                }
            }
        }
        SXSSFRow row = this.sh.createRow(this.rownum);
        ++this.rownum;
        return row;
    }

    private void setCellValueAsDouble(Cell cell, String value, ColorFormat colorFormat) {
        try {
            double d = Double.parseDouble(value);
            cell.setCellValue(d);
            if (DoubleMath.isMathematicalInteger((double)d)) {
                this.setCellStyle(cell, colorFormat, DataType.INTEGER);
            } else {
                this.setCellStyle(cell, colorFormat);
            }
        }
        catch (IllegalArgumentException e) {
            this.warningsContext.addWarning(WarningsContext.WarningType.OUTPUT_DATA_BAD_DOUBLE, value + " is not a valid number", logger);
            cell.setCellValue(value);
            this.setCellStyle(cell, colorFormat);
        }
    }

    private void setCellValueAsDate(Cell cell, String value, ColorFormat colorFormat, boolean dateOnly) {
        try {
            DateTime dateTime = this.dkuFormulaUtils.asDate(value).toDateTime(DateTimeZone.UTC);
            if (dateTime.isBefore(JAN_1_1900)) {
                cell.setCellValue(value);
                this.setCellStyle(cell, colorFormat);
            } else {
                Date date = dateTime.toLocalDateTime().toDate();
                cell.setCellValue(date);
                this.setCellStyle(cell, colorFormat, dateOnly ? DataType.DATEONLY : DataType.DATE);
            }
        }
        catch (IllegalArgumentException e) {
            this.warningsContext.addWarning(WarningsContext.WarningType.OUTPUT_DATA_BAD_DATE, value + " is not a valid date", logger);
            cell.setCellValue(value);
            this.setCellStyle(cell, colorFormat);
        }
    }

    public void footer(ColumnFactory cf, OutputStream os) throws IOException {
        int ci = 0;
        for (HeaderColumn c2 : this.headerColumns) {
            long avgChars = (long)Math.ceil((double)c2.totalChars / (double)(this.rownum + 1));
            long maxChars = Math.min(c2.maxChars, 45);
            assert (avgChars > 0L);
            int ncharsToShow = (double)maxChars / (double)avgChars > 2.0 ? (int)((maxChars + avgChars) / 2L) : (int)maxChars;
            ncharsToShow = Math.max(ncharsToShow, c2.column.getName().length());
            this.sh.setColumnWidth(ci++, ncharsToShow * 256);
        }
        logger.debug((Object)"Write excel footer");
        if (StringUtils.isBlank((String)this.password)) {
            this.wb.write(os);
            this.wb.dispose();
        } else {
            try (POIFSFileSystem fs = new POIFSFileSystem();){
                Encryptor encryptor = new EncryptionInfo(EncryptionMode.standard).getEncryptor();
                encryptor.confirmPassword(this.password);
                try (OutputStream encryptedOutputStream = encryptor.getDataStream(fs);){
                    this.wb.write(encryptedOutputStream);
                    this.wb.dispose();
                }
                fs.writeFilesystem(os);
            }
            catch (Exception e) {
                throw new IOException("Unable to save password-protected Excel file. Try again without a password.", e);
            }
        }
        logger.debug((Object)"Done writing excel footer");
    }

    public void cancel(OutputStream os) throws Exception {
        try {
            this.wb.dispose();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to close workbook", (Throwable)e);
        }
    }

    public void setWarningsContext(WarningsContext warningsContext) {
        this.warningsContext = warningsContext;
    }

    private void setCellStyle(Cell cell, @Nullable ColorFormat colorFormat) {
        this.setCellStyle(cell, colorFormat, null);
    }

    private void setCellStyle(Cell cell, @Nullable ColorFormat colorFormat, @Nullable DataType dataType) {
        if (dataType != null || colorFormat != null) {
            cell.setCellStyle(this.cellStyle(dataType, colorFormat));
        }
    }

    private ColorFormat computeCellColorFormat(com.dataiku.dip.datalayer.Row row, String columnName, String value, ColumnFactory cf) {
        return (ColorFormat)TableColoringHelper.computeCellColorFormat(row, columnName, value, cf, this.coloring, this.colorFormatFactory, null, null, null);
    }

    private ColorFormat computeCellColorFormat(com.dataiku.dip.datalayer.Row row, String columnName, String value, ColumnFactory cf, ColoringDefinition.ColoringGroup coloringGroup) {
        return (ColorFormat)TableColoringHelper.computeCellColorFormat(row, columnName, value, cf, this.coloring, this.colorFormatFactory, coloringGroup, this.coloringService, this.table);
    }

    private CellStyle cellStyle(@Nullable DataType dataType, @Nullable ColorFormat colorFormat) {
        CellStyleSpec spec = new CellStyleSpec(dataType, colorFormat);
        XSSFCellStyle style = this.cellStyles.get(spec);
        if (style == null) {
            style = (XSSFCellStyle)this.wb.createCellStyle();
            if (spec.dataType != null) {
                switch (spec.dataType) {
                    case INTEGER: {
                        style.setDataFormat(this.wb.createDataFormat().getFormat("0"));
                        break;
                    }
                    case DATE: {
                        style.setDataFormat(this.wb.createDataFormat().getFormat("yyyy-MM-dd HH:mm:ss.000"));
                        break;
                    }
                    case DATEONLY: {
                        style.setDataFormat(this.wb.createDataFormat().getFormat("yyyy-MM-dd"));
                    }
                }
            }
            if (spec.colorFormat != null) {
                if (spec.colorFormat.backgroundColor != null) {
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    style.setFillForegroundColor((XSSFColor)spec.colorFormat.backgroundColor);
                }
                if (spec.colorFormat.textColor != null) {
                    XSSFFont font = (XSSFFont)this.wb.createFont();
                    font.setColor((XSSFColor)spec.colorFormat.textColor);
                    style.setFont((Font)font);
                }
            }
            this.cellStyles.put(spec, style);
        }
        return style;
    }

    private static class HeaderColumn {
        int totalChars;
        int maxChars;
        Column column;
        boolean numeric;
        boolean temporal;
        boolean dateOnly;

        HeaderColumn(Column column, boolean numeric, boolean temporal, boolean dateOnly) {
            this.column = column;
            this.numeric = numeric;
            this.temporal = temporal;
            this.dateOnly = dateOnly;
        }
    }

    private static class ColorFormat
    extends TableColoringHelper.ColorFormat<XSSFColor> {
        private static final Pattern RGBA_PATTERN = Pattern.compile("rgba?\\(\\s*(?<red>[0-9]+)\\s*,\\s*(?<green>[0-9]+)\\s*,\\s*(?<blue>[0-9]+)\\s*(,\\s*(?<alpha>[0-9.]+)\\s*)?\\)");

        public ColorFormat(String textColor, String backgroundColor) {
            super(ColorFormat.decodeColor(textColor), ColorFormat.decodeColor(backgroundColor));
        }

        private static XSSFColor decodeColor(String textColor) {
            try {
                if (StringUtils.isNotBlank((String)textColor)) {
                    if (textColor.startsWith("#") || textColor.startsWith("0x")) {
                        return new XSSFColor(Color.decode(textColor), (IndexedColorMap)new DefaultIndexedColorMap());
                    }
                    Matcher matcher = RGBA_PATTERN.matcher(textColor);
                    if (matcher.matches()) {
                        int r = Integer.parseInt(matcher.group("red"));
                        int g = Integer.parseInt(matcher.group("green"));
                        int b = Integer.parseInt(matcher.group("blue"));
                        String alpha = matcher.group("alpha");
                        if (alpha != null && !"1".equals(alpha)) {
                            double p = Double.parseDouble(alpha);
                            r = 255 - (int)Math.round(p * (double)(255 - r));
                            g = 255 - (int)Math.round(p * (double)(255 - g));
                            b = 255 - (int)Math.round(p * (double)(255 - b));
                        }
                        return new XSSFColor(new Color(r, g, b), (IndexedColorMap)new DefaultIndexedColorMap());
                    }
                }
            }
            catch (RuntimeException e) {
                logger.error((Object)("Unable to decode color: " + textColor), (Throwable)e);
            }
            return null;
        }
    }

    private static enum DataType {
        INTEGER,
        DATE,
        DATEONLY;

    }

    private static class CellStyleSpec {
        private final DataType dataType;
        private final ColorFormat colorFormat;

        public CellStyleSpec(DataType dataType, ColorFormat colorFormat) {
            this.dataType = dataType;
            this.colorFormat = colorFormat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CellStyleSpec that = (CellStyleSpec)o;
            return this.dataType == that.dataType && Objects.equals(this.colorFormat, that.colorFormat);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.dataType, this.colorFormat});
        }
    }
}

