/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.geo;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.formats.geo.GeoJSONOutputFormatter;
import com.dataiku.dip.input.formats.ArchiveCapableFormatExtractor;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.input.formats.RowFactoryWithContextInfo;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.geotools.geojson.geom.GeometryJSON;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Geometry;

public class GeoJSONFormatExtractor
extends ArchiveCapableFormatExtractor {
    public static final FormatMeta<GeoJSONFormatExtractor, Config> META = new FormatMeta<GeoJSONFormatExtractor, Config>(){

        @Override
        public String getType() {
            return "geojson";
        }

        @Override
        public String getLabel() {
            return "GeoJSON";
        }

        @Override
        public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
            return SchemaDetection.SchemaHandlingType.NAME_BASED_VARIABLE_COLUMNS;
        }

        @Override
        public ParamDesc[] getParams() {
            return new ParamDesc[0];
        }

        @Override
        public Class<? extends FormatParams> paramsClass() {
            return Config.class;
        }

        @Override
        public FormatExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
            return new GeoJSONFormatExtractor();
        }

        @Override
        public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
            return new GeoJSONOutputFormatter();
        }
    };
    private int extractedRows;
    private static final Logger logger = Logger.getLogger((String)"dku.formats.geojson");

    @Override
    protected boolean doExtractStream(InputStreamWithContextInfo isn, ProcessorOutput out, ColumnFactory cf, RowFactory rowFactory, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
        InputStream is = isn.getInputStream();
        RowFactoryWithContextInfo rf = new RowFactoryWithContextInfo(rowFactory, isn);
        JSONObject obj = new JSONObject(IOUtils.toString((InputStream)is, (String)"utf8"));
        String rootType = obj.getString("type");
        if (!"FeatureCollection".equals(rootType)) {
            throw ErrorContext.iae((String)"Only FeatureCollection is supported");
        }
        JSONArray features = obj.getJSONArray("features");
        for (int i = 0; i < features.length(); ++i) {
            JSONObject feature = features.getJSONObject(i);
            if (this.featureToRow(feature, cf, rf, out)) continue;
            return false;
        }
        return true;
    }

    private void putGeometry(JSONObject feature, Row row, ColumnFactory cf) throws IOException, JSONException {
        Geometry geom;
        GeometryJSON geoJson = new GeometryJSON();
        if (!feature.has("geometry")) {
            throw new IOException("All features of the geojson file must have a 'geometry' key");
        }
        Column geoColumn = cf.column("the_geom");
        if (!feature.isNull("geometry") && (geom = geoJson.read((Object)feature.getJSONObject("geometry").toString())) != null) {
            row.put(geoColumn, geom.toString());
        }
    }

    protected boolean featureToRow(JSONObject feature, ColumnFactory cf, RowFactory rf, ProcessorOutput out) throws Exception {
        JSONObject properties;
        Row row = rf.row();
        if (!feature.has("properties")) {
            throw new IOException("All features of the geojson file must have a 'properties' key");
        }
        JSONObject jSONObject = properties = !feature.isNull("properties") ? feature.getJSONObject("properties") : new JSONObject();
        if (this.schema != null) {
            for (SchemaColumn existingCol : this.schema.columns) {
                if (existingCol.getName().equals("the_geom")) {
                    this.putGeometry(feature, row, cf);
                    continue;
                }
                if (!properties.has(existingCol.getName())) continue;
                row.put(cf.column(existingCol.getName()), properties.get(existingCol.getName()).toString());
            }
        } else {
            this.putGeometry(feature, row, cf);
            Iterator keyIt = properties.keys();
            while (keyIt.hasNext()) {
                String key = (String)keyIt.next();
                row.put(cf.column(key), properties.get(key).toString());
            }
        }
        out.emitRow(row);
        ++this.extractedRows;
        if (this.limit != null && this.limit.maxRecords > 0L && (long)this.extractedRows > this.limit.maxRecords) {
            logger.info((Object)"limit reached");
            return false;
        }
        return true;
    }

    public static class Config
    implements FormatParams {
    }
}

