/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.futures.FutureKernelHandle;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressStateSnapshot;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureServiceBase;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.IFutureKernelsManager;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FutureService
extends FutureServiceBase {
    @Autowired
    private ScenarioRunContext scenarioRunContext;
    @Autowired
    protected IFutureKernelsManager kernelsManager;
    private final Semaphore maxConcurrentFEK = new Semaphore(ApplicationConfigurator.getParams().getIntParam("dku.futures.pool.maxConcurrentFEKs", Integer.valueOf(30)), true);
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.future");

    public <T> FutureResponse<T> runFuture(FutureThreadBase<T> ft, long waitTimeoutInMs, TypeToken<? extends FutureResponse<T>> resultClass) throws Exception {
        boolean execFutureLocally = DKUApp.getParams().getBoolParam("dku.futures.exec.local", false);
        if (!execFutureLocally && ft.getDangerosity() > 0.5 && this.kernelsManager.isUsable()) {
            return this.safeRunFuture(new RemoteFutureThread((FutureThread)ft, resultClass), 0L);
        }
        return this.safeRunFuture(ft, waitTimeoutInMs);
    }

    public <T> FutureResponse<T> runFutureOnFEKAndWaitForKernel(FutureThreadBase<T> ft, TypeToken<? extends FutureResponse<T>> resultClass) throws Exception {
        RemoteFutureThread remoteFutureThread = new RemoteFutureThread((FutureThread)ft, resultClass);
        remoteFutureThread.acquireKernel();
        return this.safeRunFuture(remoteFutureThread, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> FutureResponse<T> waitForFinalResponse(String jobId) throws Exception {
        int delay = 25;
        try {
            FutureResponse reponse;
            do {
                Thread.sleep(delay);
                delay = Math.min(delay + 25, 500);
                reponse = this.getUpdate(jobId);
            } while (!reponse.hasResult);
            return reponse;
        }
        catch (InterruptedException ex) {
            FutureService futureService = this;
            synchronized (futureService) {
                FutureThreadBase ft = (FutureThreadBase)this.runningJobs.get(jobId);
                if (ft != null && ft instanceof RemoteFutureThread && ft.aborted) {
                    this.runningJobs.remove(jobId);
                }
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> FutureResponse<T> waitForCompletion(String jobId) throws Exception {
        int delay = 25;
        try {
            FutureResponse response;
            do {
                Thread.sleep(delay);
                delay = Math.min(delay + 25, 500);
                response = this.getProgress(jobId);
            } while (!response.hasResult);
            return response;
        }
        catch (InterruptedException ex) {
            FutureService futureService = this;
            synchronized (futureService) {
                FutureThreadBase ft = (FutureThreadBase)this.runningJobs.get(jobId);
                if (ft != null && ft instanceof RemoteFutureThread && ft.aborted) {
                    this.runningJobs.remove(jobId);
                }
            }
            throw ex;
        }
    }

    public void invalidateKernels() {
        this.kernelsManager.invalidateKernels();
    }

    private final class RemoteFutureThread<T>
    extends FutureThread<T> {
        private final FutureThread<T> remote;
        private FutureResponse<T> currentReponse;
        private FutureKernelHandle kernel;
        private final TypeToken<? extends FutureResponse<T>> responseClass;
        private boolean abortSent;

        RemoteFutureThread(FutureThread<T> remote, TypeToken<? extends FutureResponse<T>> responseClass) {
            super(remote.getOwner());
            this.abortSent = false;
            this.remote = remote;
            this.responseClass = responseClass;
        }

        private void acquireKernel() throws Exception {
            this.kernel = FutureService.this.kernelsManager.acquireKernel(this.remote.getOwner(), this.remote.jobId);
        }

        private void startRemoteExecution() throws IOException {
            logger.infoV("Initiating remote execution of job %s on remote kernel %s", new Object[]{this.remote.jobId, this.kernel.getId()});
            ScenarioRun scenarioRun = FutureService.this.scenarioRunContext.getScenarioRun();
            if (scenarioRun == null) {
                this.kernel.apiClient.postFormToJSON("/future/start", Void.class, new Object[]{"jobId", this.remote.jobId, "futureThreadClassName", ((Object)this.remote).getClass().getName(), "futureThreadDefinition", JSON.json(this.remote), "ticketSecret", this.kernel.getTicket().getSecret()});
            } else {
                this.kernel.apiClient.postFormToJSON("/future/start", Void.class, new Object[]{"jobId", this.remote.jobId, "futureThreadClassName", ((Object)this.remote).getClass().getName(), "futureThreadDefinition", JSON.json(this.remote), "ticketSecret", this.kernel.getTicket().getSecret(), "scenarioRun", JSON.json((Object)scenarioRun)});
            }
        }

        protected String getNameForThreadNameAndMetrics() {
            String clazzName = ((Object)this.remote).getClass().getSimpleName();
            if (StringUtils.isEmpty((String)clazzName)) {
                clazzName = ((Object)this.remote).getClass().toString().replaceAll("\\.", "");
            }
            return "RemoteFutureFor." + clazzName;
        }

        public FuturePayload getPayload() {
            return FutureServiceBase.buildFuturePayload((FuturePayload)this.remote.getPayload());
        }

        public double getDangerosity() {
            return 0.0;
        }

        public T getResult() {
            return (T)(this.currentReponse != null ? this.currentReponse.result : null);
        }

        @Override
        public Integer getUsedFekPort() {
            return this.kernel != null ? Integer.valueOf(this.kernel.getPort()) : null;
        }

        public FutureProgressStateSnapshot getProgressSnapshot() {
            return this.currentReponse != null ? this.currentReponse.progress : super.getProgressSnapshot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            RemoteFutureThread remoteFutureThread = this;
            synchronized (remoteFutureThread) {
                if (this.abortSent) {
                    logger.info((Object)"Already received abort request for remote future thread, ignoring duplicate abort request");
                    return;
                }
                logger.info((Object)("Aborting remote future thread: " + String.valueOf((Object)this)));
                this.abortSent = true;
            }
            super.abort();
        }

        private void postExecuteCleanup(boolean didAcquireSemaphore) {
            new Thread(() -> {
                block13: {
                    block11: {
                        block12: {
                            block9: {
                                block10: {
                                    try {
                                        if (this.kernel != null) break block9;
                                        logger.infoV("FEK was never acquired for job %s, no remote process to abort", new Object[]{this.remote.jobId});
                                        if (!didAcquireSemaphore) break block10;
                                        FutureService.this.maxConcurrentFEK.release();
                                    }
                                    catch (Throwable throwable) {
                                        if (didAcquireSemaphore) {
                                            FutureService.this.maxConcurrentFEK.release();
                                            logger.infoV("Future released semaphore, currently about %d waiting", new Object[]{FutureService.this.maxConcurrentFEK.getQueueLength()});
                                        }
                                        throw throwable;
                                    }
                                    logger.infoV("Future released semaphore, currently about %d waiting", new Object[]{FutureService.this.maxConcurrentFEK.getQueueLength()});
                                }
                                return;
                            }
                            if (this.currentReponse == null || !this.currentReponse.hasResult) break block11;
                            logger.infoV("Job %s completed on remote process %s, will release kernel", new Object[]{this.remote.jobId, this.kernel.getId()});
                            FutureService.this.kernelsManager.releaseKernel(this.kernel);
                            if (!didAcquireSemaphore) break block12;
                            FutureService.this.maxConcurrentFEK.release();
                            logger.infoV("Future released semaphore, currently about %d waiting", new Object[]{FutureService.this.maxConcurrentFEK.getQueueLength()});
                        }
                        return;
                    }
                    logger.infoV("Sending abort job %s to the remote process %s", new Object[]{this.remote.jobId, this.kernel.getId()});
                    try {
                        int apiTimeout = 30000;
                        this.kernel.apiClient.postFormToJSON("/future/abort", apiTimeout, Void.class, new Object[]{"futureId", this.remote.jobId});
                        int waitTimeout = 60000;
                        boolean isGone = this.waitForKernelAbort(waitTimeout, apiTimeout);
                        if (!isGone) {
                            FutureService.this.kernelsManager.releaseAndKillKernel(this.kernel);
                        } else {
                            FutureService.this.kernelsManager.releaseKernel(this.kernel);
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)"Failed to abort remote future: proceeding to termination", (Throwable)e);
                        FutureService.this.kernelsManager.releaseAndKillKernel(this.kernel);
                    }
                    if (!didAcquireSemaphore) break block13;
                    FutureService.this.maxConcurrentFEK.release();
                    logger.infoV("Future released semaphore, currently about %d waiting", new Object[]{FutureService.this.maxConcurrentFEK.getQueueLength()});
                }
            }).start();
        }

        private boolean waitForKernelAbort(int waitTimeout, int apiTimeout) {
            boolean isGone = false;
            try {
                long waitMax = System.currentTimeMillis() + (long)waitTimeout;
                int delay = 500;
                while (!isGone && System.currentTimeMillis() < waitMax) {
                    FutureServiceBase.FutureLiveliness liveliness = (FutureServiceBase.FutureLiveliness)this.kernel.apiClient.postFormToJSON("/future/check-abort", apiTimeout, FutureServiceBase.FutureLiveliness.class, new Object[]{"futureId", this.remote.jobId});
                    if (liveliness == null) {
                        throw new IOException("Kernel hang");
                    }
                    logger.info((Object)("Check abort said " + (liveliness.alive ? "alive" : "dead") + " and " + (liveliness.registered ? "registered" : "forgotten")));
                    isGone = !liveliness.alive;
                    Thread.sleep(delay);
                    delay *= 2;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn((Object)"Abort monitoring thread was interrupted, giving up");
            }
            catch (IOException e) {
                logger.warn((Object)"Kernel stopped responding altogether, proceeding to termination", (Throwable)e);
            }
            return isGone;
        }

        public void postRunCleanup() {
            this.remote.postRunCleanup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws Exception {
            boolean didAcquireSemaphore = false;
            try (DSSMetrics.MTimeCtx tctx = DSSMetrics.mtimeCtx((String[])new String[]{"dku.futures.remoteExecute.overall", "dku.futures.remoteExecute.byClass." + ((Object)this.remote).getClass().getSimpleName()});){
                if (this.kernel == null) {
                    logger.infoV("Future acquiring semaphore, currently about %d waiting", new Object[]{FutureService.this.maxConcurrentFEK.getQueueLength()});
                    FutureService.this.maxConcurrentFEK.acquire();
                    didAcquireSemaphore = true;
                    this.acquireKernel();
                }
                logger.infoV("Kernel %s acquired", new Object[]{this.kernel.getId()});
                this.startRemoteExecution();
                FutureProgress currentProgress = FutureProgress.getLocalDangerous();
                int delay = 50;
                while (true) {
                    Thread.sleep(delay);
                    delay = Math.min(delay + 50, 500);
                    this.currentReponse = (FutureResponse)this.kernel.apiClient.postFormToJSON("/future/get-status", this.responseClass, new Object[]{"futureId", this.remote.jobId});
                    if (this.currentReponse.hasResult) break;
                    if (currentProgress == null || this.currentReponse.progress == null) continue;
                    FutureProgress futureProgress = currentProgress;
                    synchronized (futureProgress) {
                        currentProgress.stateStack = this.currentReponse.progress;
                    }
                }
                this.currentReponse = (FutureResponse)this.kernel.apiClient.postFormToJSON("/future/get-update", this.responseClass, new Object[]{"futureId", this.remote.jobId});
                if (currentProgress != null) {
                    currentProgress.stateStack.clear();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                logger.info((Object)"Remote future waiting thread interrupted, sending abort to kernel");
            }
            finally {
                this.postExecuteCleanup(didAcquireSemaphore);
            }
        }
    }
}

