/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport.wikis.execution;

import com.dataiku.dip.graphicsexport.wikis.execution.WikiArticleLinksEditor;
import com.dataiku.dip.graphicsexport.wikis.model.WikiExportTarget;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;

public class WikiArticleMerger {
    private final File rawExportDirectory;
    private final PDFMergerUtility pdfMerger;
    private final Map<String, PDOutlineItem> bookmarkMap;
    private final WikiArticleLinksEditor wikiArticleLinksEditor;

    public WikiArticleMerger(File rawExportDirectory, WikiArticleLinksEditor wikiArticleLinksEditor) {
        this.rawExportDirectory = rawExportDirectory;
        this.wikiArticleLinksEditor = wikiArticleLinksEditor;
        this.pdfMerger = new PDFMergerUtility();
        this.bookmarkMap = new HashMap<String, PDOutlineItem>();
    }

    public void mergeFullPDFs(List<WikiExportTarget> articles, File targetFile) throws IOException {
        try (PDDocument finalPDF = new PDDocument();){
            PDDocumentOutline outline = new PDDocumentOutline();
            for (WikiExportTarget article : articles) {
                this.addArticleToPDF(finalPDF, article, (PDOutlineNode)outline);
            }
            finalPDF.getDocumentCatalog().setDocumentOutline(outline);
            PDDocumentInformation pdfInfo = new PDDocumentInformation();
            pdfInfo.setAuthor("Dataiku DSS");
            pdfInfo.setCreator("Dataiku DSS");
            pdfInfo.setCreationDate(Calendar.getInstance());
            pdfInfo.setModificationDate(Calendar.getInstance());
            finalPDF.setDocumentInformation(pdfInfo);
            this.wikiArticleLinksEditor.editInternalLinks(finalPDF, this.bookmarkMap);
            finalPDF.save(targetFile);
        }
    }

    private void addArticleToPDF(PDDocument finalPDF, WikiExportTarget target, PDOutlineNode parentBookmark) throws IOException {
        File source = this.getFileFromId(target.article.id);
        int pageCount = finalPDF.getNumberOfPages();
        try (PDDocument currentDocument = PDDocument.load((File)source);){
            this.pdfMerger.appendDocument(finalPDF, currentDocument);
        }
        PDOutlineItem bookmark = this.buildBookmark(target.article.name, finalPDF.getPage(pageCount));
        this.bookmarkMap.put(target.article.id, bookmark);
        for (WikiExportTarget child : target.children) {
            this.addArticleToPDF(finalPDF, child, (PDOutlineNode)bookmark);
        }
        parentBookmark.addLast(bookmark);
    }

    private PDOutlineItem buildBookmark(String articleName, PDPage page) {
        PDOutlineItem bookmark = new PDOutlineItem();
        bookmark.setTitle(articleName);
        bookmark.setDestination(page);
        return bookmark;
    }

    private File getFileFromId(String articleId) {
        return new File(this.rawExportDirectory, articleId + ".pdf");
    }
}

