/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.cluster.ClusterDependentKernelHandle;
import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class HProxyKernelHandle
extends ClusterDependentKernelHandle {
    private AutoDelete tmpDir;

    public HProxyKernelHandle(String hproxyId, String key) {
        super("hproxy", hproxyId, key);
    }

    @Override
    protected ProcessBuilder getProcessBuilder(ClusterSettings clusterSettings) throws Exception {
        String hproxyBin = System.getenv("DKUHPROXYBIN");
        if (hproxyBin == null) {
            throw new Error("environment variable DKUHPROXYBIN not defined");
        }
        ArrayList args = Lists.newArrayList((Object[])new String[]{hproxyBin, this.getKernelId()});
        ProcessBuilder pb = new ProcessBuilder(args);
        HiveSettings hiveSettings = clusterSettings.getHiveSettings();
        pb.environment().put("DKU_HIVE_ADDITIONAL_JARS", StringUtils.defaultIfBlank((String)hiveSettings.hiveAdditionalJars, (String)""));
        pb.environment().put("DKU_HIVE_SPARK_HOME", StringUtils.defaultIfBlank((String)hiveSettings.hiveSparkHome, (String)""));
        AutoDelete privTmp = DSSTempUtils.getTempFile((String)"hvk-startup-settings", (String)"cluster-settings", (String)"json");
        JSON.prettyToFile((Object)clusterSettings, (File)privTmp);
        pb.environment().put("DKU_CLUSTER_SETTINGS_FILE", privTmp.getAbsolutePath());
        HadoopSettings hadoopSettings = clusterSettings.getHadoopSettings();
        for (ClusterProperty prop : hadoopSettings.validationKernelsExtraEnv) {
            logger.info((Object)("Adding to HVK env " + prop.key + " = " + prop.value));
            if (StringUtils.isBlank((String)prop.value)) continue;
            pb.environment().put(prop.key, prop.value);
        }
        pb.environment().put("DKU_HPROXY_ID", this.getKernelId());
        this.tmpDir = DSSTempUtils.getTempFolder((String)"hive-validation-kernel", (String)"run");
        return pb;
    }

    @Override
    protected List<AutoCloseable> getProcessResourcesToClose() {
        ArrayList ret = Lists.newArrayList();
        if (this.tmpDir != null) {
            ret.add(this.tmpDir);
        }
        return ret;
    }

    @Override
    protected File getRunDir() {
        return this.tmpDir;
    }

    @Override
    protected void ping() throws Exception {
        this.getAPIClient().postObject("/hproxy/ping", JsonObject.class, (Object)new JsonObject());
    }

    @Override
    protected void tryThrowingError() throws Exception {
        File errorFile = new File((File)this.tmpDir, "error.json");
        if (errorFile.exists() && errorFile.length() > 0L) {
            SerializedError err = null;
            try {
                err = (SerializedError)JSON.parseFile((File)new File((File)this.tmpDir, "error.json"), SerializedError.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (err != null) {
                throw new APIError.SerializedErrorException(err);
            }
        }
        logger.error((Object)"Could not retrieve HVK  error details");
    }
}

