/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.i18n;

import com.dataiku.dip.i18n.UserLocaleAware;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
@Order(value=2)
public class LocaleContextAspect {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private UIAuthService authService;
    private static final DKULogger logger = DKULogger.getLogger(LocaleContextAspect.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(userLocaleAware)")
    public Object setLocaleContext(ProceedingJoinPoint pjp, UserLocaleAware userLocaleAware) throws Throwable {
        block12: {
            try {
                ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                HttpServletRequest request = null;
                if (attributes != null) {
                    request = attributes.getRequest();
                }
                if (request == null) break block12;
                try (Transaction t = this.transactionService.beginRead(IsolationLevel.YOLO);){
                    AuthCtx user = this.authService.getMandatoryUser(request);
                    LocaleContextHolder.setLocale((Locale)Locale.forLanguageTag(this.userSettingsService.getLangForUser(user.getIdentifier())), (boolean)true);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Setting locale based on user failed", (Throwable)e);
            }
        }
        try {
            Object object = pjp.proceed();
            return object;
        }
        finally {
            LocaleContextHolder.resetLocaleContext();
        }
    }
}

