/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive.orcfile;

import com.dataiku.dip.input.formats.hive.HiveFileFormatConfig;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ORCFileFormatConfig
extends HiveFileFormatConfig {
    public static final String DEFAULT_SERDE_CLASS = "org.apache.hadoop.hive.ql.io.orc.OrcSerde";
    protected static final SortedMap<String, String> DEFAULT_SERDE_PROPERTIES = new TreeMap<String, String>();
    public CompressionMethod compressionMethod = CompressionMethod.SNAPPY;
    public ReadTemporalMode readTemporalMode = ReadTemporalMode.AS_TEMPORAL;

    @Override
    public String getDefaultSerdeClass() {
        return DEFAULT_SERDE_CLASS;
    }

    public SortedMap<String, String> getDefaultSerdeProperties() {
        return DEFAULT_SERDE_PROPERTIES;
    }

    @Override
    protected Map<String, String> getDefaultTableProperties() {
        HashMap tblProps = Maps.newHashMap();
        if (this.compressionMethod != null) {
            tblProps.put("orc.compress", this.compressionMethod.name());
        }
        return tblProps;
    }

    public static enum CompressionMethod {
        NONE,
        ZLIB,
        SNAPPY;

    }

    public static enum ReadTemporalMode {
        AS_STRING,
        AS_TEMPORAL;

    }
}

