/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.webhook;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.integrations.AbstractHttpIntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationMeta;
import com.dataiku.dip.integrations.IntegrationParams;
import com.dataiku.dip.integrations.webhook.AbstractWebhookIntegrationParams;
import com.dataiku.dip.scheduler.reports.ScenarioReportEvent;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DefaultRedirectStrategyWithIPBlacklist;
import com.dataiku.dip.security.IPBlacklistVerifier;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertEvent;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpException;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.RedirectStrategy;
import com.dataiku.dss.shadelib.org.apache.http.client.config.RequestConfig;
import com.dataiku.dss.shadelib.org.apache.http.client.entity.UrlEncodedFormEntity;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpDelete;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPatch;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPut;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpRequestBase;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.http.entity.ContentType;
import com.dataiku.dss.shadelib.org.apache.http.entity.StringEntity;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicNameValuePair;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;

public class WebhookIntegrationHandler
extends AbstractHttpIntegrationEventHandler {
    public static final IntegrationMeta SCENARIO_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "webhook-scenario";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return AbstractWebhookIntegrationParams.WebhookIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) {
            return new WebhookIntegrationHandler(messaging.getConfigurationAs(AbstractWebhookIntegrationParams.WebhookIntegrationParams.class));
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
        }
    };
    public static final IntegrationMeta UNIFIED_MONITORING_ALERTING_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "webhook-unified-monitoring-alerting";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return AbstractWebhookIntegrationParams.WebhookIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) {
            return new WebhookIntegrationHandler(messaging.getConfigurationAs(AbstractWebhookIntegrationParams.WebhookIntegrationParams.class));
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
        }
    };
    private final AbstractWebhookIntegrationParams.WebhookIntegrationParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.sender.webhook");

    public WebhookIntegrationHandler(AbstractWebhookIntegrationParams.WebhookIntegrationParams params) {
        this.params = params;
    }

    @Override
    public void handleEvent(DSSEvent event, InfoMessage.InfoMessages messages) throws Exception {
        int responseCode;
        VariableLookup lookup;
        if (event instanceof ScenarioReportEvent) {
            ScenarioReportEvent sre = (ScenarioReportEvent)event;
            lookup = sre.lookup;
        } else if (event instanceof UnifiedMonitoringAlertEvent) {
            UnifiedMonitoringAlertEvent ume = (UnifiedMonitoringAlertEvent)event;
            lookup = ume.lookup;
        } else {
            throw new IllegalStateException("Event type %s not handled for webhooks".formatted(event.getClass().getName()));
        }
        StringSubstitutor substitutor = new StringSubstitutor((StringLookup)lookup);
        String url = substitutor.replace(this.params.url);
        logger.info((Object)("Webhook to url : " + url));
        ProxySettings proxySettings = new ProxySettings();
        if (this.params.useProxy) {
            proxySettings = ApplicationConfigurator.getProxySettings();
        }
        IPBlacklistVerifier.validateUriNotBlacklisted(url, proxySettings);
        DefaultRedirectStrategyWithIPBlacklist redirectStrategy = new DefaultRedirectStrategyWithIPBlacklist(proxySettings);
        URIBuilder builder = new URIBuilder(url);
        for (SimpleKeyValue header : this.params.parameters) {
            builder.addParameter(header.key, substitutor.replace(header.value));
        }
        URI uri = builder.build();
        final HttpRequestBase request = this.createRequest(this.params.method, uri);
        String declaredContentType = null;
        for (SimpleKeyValue header : this.params.headers) {
            String value = substitutor.replace(header.value);
            request.addHeader(header.key, value);
            if (!header.key.equalsIgnoreCase("Content-Type")) continue;
            declaredContentType = value;
        }
        if (request instanceof HttpEntityEnclosingRequestBase) {
            logger.info((Object)("Preparing " + this.params.method + " request : handling body of type " + this.params.mime));
            HttpEntityEnclosingRequestBase entityRequest = (HttpEntityEnclosingRequestBase)request;
            if (StringUtils.isNotBlank((String)this.params.mime) && this.params.mime.equals("application/x-www-form-urlencoded")) {
                logger.info((Object)"Preparing form");
                request.addHeader("Content-type", this.params.mime);
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                for (SimpleKeyValue kv : this.params.form) {
                    nvps.add(new BasicNameValuePair(kv.key, substitutor.replace(kv.value)));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8);
                entityRequest.setEntity((HttpEntity)entity);
            } else if (StringUtils.isNotBlank((String)this.params.payload)) {
                StringEntity entity;
                logger.info((Object)"Preparing payload");
                if (StringUtils.isNotBlank((String)this.params.mime)) {
                    if (StringUtils.isBlank((String)declaredContentType)) {
                        request.addHeader("Content-type", this.params.mime);
                    }
                    entity = new StringEntity(substitutor.replace(this.params.payload), StandardCharsets.UTF_8);
                } else {
                    entity = new StringEntity(substitutor.replace(this.params.payload), ContentType.create((String)this.params.mime, (String)StandardCharsets.UTF_8.name()));
                }
                entityRequest.setEntity((HttpEntity)entity);
            }
        }
        int timeoutS = DKUApp.getParams().getIntParam("dku.scenario.webhook.timeoutS", Integer.valueOf(300));
        logger.info((Object)("Setting timeouts to " + timeoutS + " s"));
        final int timeoutMs = timeoutS * 1000;
        RequestConfig rc = RequestConfig.custom().setConnectTimeout(timeoutMs).setConnectionRequestTimeout(10000).setSocketTimeout(timeoutMs).build();
        request.setConfig(rc);
        Thread timeoutThread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(timeoutMs);
                    logger.warn((Object)"Webhook took too long, aborting");
                    request.abort();
                }
                catch (InterruptedException e) {
                    logger.info((Object)"Exiting timeout thread");
                }
                catch (Exception e) {
                    logger.warn((Object)"Could not abort webhook call", (Throwable)e);
                }
            }
        };
        timeoutThread.setDaemon(true);
        timeoutThread.start();
        try (AbstractHttpIntegrationEventHandler.AutoCloseableClient client = this.getClient(this.params.useProxy, (RedirectStrategy)redirectStrategy);
             FutureAborter.AutoCloseableAbortHook abortHook = FutureAborter.pushAutoCloseableHook(() -> {
            logger.info((Object)"Abort request of webhook");
            request.abort();
        });){
            HttpResponse response = null;
            try {
                response = client.execute((HttpUriRequest)request);
                String responseText = response.getEntity() != null ? IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"utf8") : "";
                responseCode = response.getStatusLine().getStatusCode();
                logger.info((Object)("Webhook responded " + response.getStatusLine().getStatusCode() + " (" + response.getStatusLine().getReasonPhrase() + ") : " + responseText));
            }
            catch (IOException e) {
                logger.error((Object)"Failed to run webhook", (Throwable)e);
                throw e;
            }
            finally {
                if (response != null) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
                timeoutThread.interrupt();
            }
        }
        if (responseCode >= 300) {
            logger.warn((Object)("Webhook problem, status code is error : " + responseCode));
            throw new HttpException("The webhook has sent back an error code (" + responseCode + "). Check the route/method/credentials. See the scenario log for more details.");
        }
    }

    private HttpRequestBase createRequest(String method, URI uri) throws Exception {
        switch (method) {
            case "POST": {
                return new HttpPost(uri);
            }
            case "GET": {
                return new HttpGet(uri);
            }
            case "PUT": {
                return new HttpPut(uri);
            }
            case "PATCH": {
                return new HttpPatch(uri);
            }
            case "DELETE": {
                return new HttpDelete(uri);
            }
        }
        throw new Exception("Method not supported : " + method);
    }
}

