/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.io.BinaryStreamDecoderRAF;
import com.dataiku.dip.io.StringBlock;
import com.dataiku.dip.pivot.backend.model.CorruptedDataException;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.NotImplementedException;
import org.apache.fontbox.ttf.BufferedRandomAccessFile;

public class ColumnBlock {
    private final int records;
    public int[] ints;
    public double[] doubles;
    public StringBlock strings;
    public boolean fellBack = false;
    public List<String> stringDict;
    public String name;
    private MemoryType memType;
    @Nullable
    public Type realType;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.pivot");

    public ColumnBlock(BufferedRandomAccessFile stream) throws IOException {
        BinaryStreamDecoderRAF decoder = new BinaryStreamDecoderRAF(stream);
        try {
            this.memType = MemoryType.values()[decoder.readByte()];
            this.records = decoder.readLE32();
            switch (this.memType) {
                case DOUBLE: {
                    this.doubles = new double[this.records];
                    decoder.readRawDoubleBlock(this.records, this.doubles);
                    break;
                }
                case STRING: {
                    this.strings = new StringBlock(this.records);
                    decoder.readLE32Block(this.records, this.strings.lengths);
                    int total = 0;
                    for (int i = 0; i < this.records; ++i) {
                        int l = this.strings.lengths[i];
                        this.strings.offsets[i] = total;
                        total += l;
                    }
                    int utfLength = decoder.readLE32();
                    this.strings.data = decoder.readUTF8(utfLength);
                    break;
                }
                case STRING_DICT: {
                    this.ints = new int[this.records];
                    decoder.readLE32Block(this.records, this.ints);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read memory type or record count: possible data corruption", (Throwable)e);
            throw new CorruptedDataException("Data inconsistency detected, please clear your chart cache or create a new sampling.");
        }
    }

    public ColumnBlock(MemoryType memType, int nbRecords) {
        this.memType = memType;
        this.records = nbRecords;
        switch (memType) {
            case DOUBLE: {
                this.doubles = new double[this.records];
                break;
            }
            case STRING: {
                this.strings = new StringBlock(nbRecords);
                break;
            }
            case STRING_DICT: {
                throw new Error("Can't create a new String_DICT block");
            }
        }
    }

    public MemoryType getMemoryType() {
        return this.memType;
    }

    public int nbRecords() {
        return this.records;
    }

    public String getAsStringSlow(int index) {
        switch (this.memType) {
            case DOUBLE: {
                if (Double.isNaN(this.doubles[index])) {
                    return null;
                }
                return this.doubles[index] == (double)((long)this.doubles[index]) ? Long.toString((long)this.doubles[index]) : Double.toString(this.doubles[index]);
            }
            case STRING: {
                return this.strings.getSlow(index);
            }
            case STRING_DICT: {
                assert (this.stringDict != null);
                int idx = this.ints[index];
                if (idx == 0) {
                    return null;
                }
                return this.stringDict.get(idx);
            }
        }
        throw new NotImplementedException();
    }

    public static enum MemoryType {
        DOUBLE,
        STRING,
        STRING_DICT;

    }
}

