/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.io.BinaryStreamEncoder;
import com.dataiku.dip.io.ColumnBlock;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class ColumnBlockWriter {
    private final StringBuilder stringBuilder = new StringBuilder();
    private int[] strLengths;
    private int written;
    private final ColumnBlock.MemoryType memType;
    private int[] ints;
    private double[] doubles;
    public Map<String, Integer> stringReverse;
    public List<String> stringForward;

    public void flush(BinaryStreamEncoder encoder) throws IOException {
        encoder.writeByte((byte)this.memType.ordinal());
        encoder.writeLE32(this.written);
        switch (this.memType) {
            case DOUBLE: {
                for (int i = 0; i < this.written; ++i) {
                    long lng = Double.doubleToLongBits(this.doubles[i]);
                    encoder.writeLE64(lng);
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < this.written; ++i) {
                    encoder.writeLE32(this.strLengths[i]);
                }
                byte[] utf8Data = this.stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
                encoder.writeLE32(utf8Data.length);
                encoder.writeBytes(utf8Data);
                break;
            }
            case STRING_DICT: {
                for (int i = 0; i < this.written; ++i) {
                    encoder.writeLE32(this.ints[i]);
                }
                break;
            }
        }
    }

    public ColumnBlockWriter(ColumnBlock.MemoryType type, int records) {
        this.memType = type;
        switch (this.memType) {
            case DOUBLE: {
                this.doubles = new double[records];
                break;
            }
            case STRING: {
                this.strLengths = new int[records];
                break;
            }
            case STRING_DICT: {
                this.ints = new int[records];
            }
        }
    }

    public void append(double data) {
        assert (this.memType == ColumnBlock.MemoryType.DOUBLE) : "Trying to write double " + data + " in col of type " + String.valueOf((Object)this.memType);
        this.doubles[this.written++] = data;
    }

    public void append(String data) {
        if (data == null || data.length() == 0) {
            this.strLengths[this.written] = 0;
        } else {
            this.strLengths[this.written] = data.length();
            this.stringBuilder.append(data);
        }
        ++this.written;
    }

    public void appendForDict(String data) {
        if (data == null || data.isEmpty()) {
            this.ints[this.written++] = 0;
        } else {
            Integer bin = this.stringReverse.get(data);
            if (bin == null) {
                bin = this.stringReverse.size();
                this.stringReverse.put(data, bin);
                this.stringForward.add(data);
            }
            this.ints[this.written++] = bin;
        }
    }

    public ColumnBlock.MemoryType getMemoryType() {
        return this.memType;
    }
}

