/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.labeling.BaseLabelingAnswer;
import com.dataiku.dip.labeling.LabelingAnswer;
import com.dataiku.dip.labeling.LabelingInternalDBService;
import com.dataiku.dip.labeling.LabelingRecord;
import com.dataiku.dip.labeling.LabelingRecordToAnnotate;
import com.dataiku.dip.labeling.LabelingService;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.ReviewRecordInfo;
import com.dataiku.dip.labeling.TokenizedTextLabelingTask;
import com.dataiku.dip.labeling.VerifiedLabelingAnswer;
import com.dataiku.dip.labeling.text.TokenizedTextLabelingRecord;
import com.dataiku.dip.labeling.text.Tokenizer;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AnnotationService {
    @Autowired
    private LabelingInternalDBService labelingInternalDBService;
    @Autowired
    private LabelingService labelingService;

    public LabelingRecordToAnnotate getNextRecordToAnnotate(AuthCtx user, LabelingTask labelingTask, @Nullable String currentRecordId) throws Exception {
        Dataset metadataDataset = this.labelingService.getMetadataDataset(labelingTask);
        List<LabelingRecord> records = this.labelingInternalDBService.getNextRecordsToAnnotate(user, labelingTask, metadataDataset, 1, currentRecordId);
        for (LabelingRecord record : records) {
            this.enrichRecord(record, labelingTask);
        }
        LabelingRecord record = records.size() > 0 ? records.get(0) : null;
        return new LabelingRecordToAnnotate(record);
    }

    @Nullable
    public LabelingRecord getRecord(AuthCtx authCtx, LabelingTask labelingTask, String recordId) throws Exception {
        Dataset metadataDataset = this.labelingService.getMetadataDataset(labelingTask);
        LabelingRecord record = this.labelingInternalDBService.getRecord(authCtx, labelingTask, metadataDataset, recordId);
        this.enrichRecord(record, labelingTask);
        return record;
    }

    private void enrichRecord(LabelingRecord record, LabelingTask labelingTask) {
        if (labelingTask.type == LabelingTask.LabelingTaskType.NAMED_ENTITY_EXTRACTION) {
            Tokenizer tokenizer = Tokenizer.getTokenizer(((TokenizedTextLabelingTask)labelingTask).tokenizationParam);
            TokenizedTextLabelingRecord textRecord = (TokenizedTextLabelingRecord)record;
            textRecord.setTokens(tokenizer.tokenize(textRecord.text));
        }
    }

    public List<String> getRecordIdsToReview(AuthCtx authCtx, LabelingTask labelingTask) throws Exception {
        Dataset metadataDataset = this.labelingService.getMetadataDataset(labelingTask);
        return this.labelingInternalDBService.getAnnotatedButNotReviewedRecordIds(authCtx, labelingTask, metadataDataset);
    }

    public List<String> getReviewedRecordIds(AuthCtx authCtx, LabelingTask labelingTask) throws Exception {
        Dataset metadataDataset = this.labelingService.getMetadataDataset(labelingTask);
        return this.labelingInternalDBService.getReviewedRecordIds(authCtx, labelingTask, metadataDataset);
    }

    public List<ReviewRecordInfo> listReviewRecordInfo(AuthCtx authCtx, LabelingTask labelingTask, List<String> recordIds) throws Exception {
        if (recordIds == null || recordIds.isEmpty()) {
            return Collections.emptyList();
        }
        Dataset metadataDataset = this.labelingService.getMetadataDataset(labelingTask);
        List<LabelingRecord> records = this.labelingInternalDBService.getRecords(authCtx, labelingTask, metadataDataset, recordIds);
        ArrayList<ReviewRecordInfo> results = new ArrayList<ReviewRecordInfo>();
        for (LabelingRecord record : records) {
            VerifiedLabelingAnswer verifiedAnswer = this.labelingInternalDBService.getVerified(authCtx, labelingTask, record.id).orElse(null);
            List<LabelingAnswer> answers = this.labelingInternalDBService.listNotReviewed(authCtx, labelingTask, record.id);
            this.enrichRecordToReview(record, labelingTask, answers, verifiedAnswer);
            results.add(new ReviewRecordInfo(labelingTask, record, verifiedAnswer, answers));
        }
        return results;
    }

    private void enrichRecordToReview(LabelingRecord record, LabelingTask labelingTask, List<LabelingAnswer> answers, VerifiedLabelingAnswer verifiedAnswer) {
        if (labelingTask.type == LabelingTask.LabelingTaskType.NAMED_ENTITY_EXTRACTION) {
            TokenizedTextLabelingRecord textRecord = (TokenizedTextLabelingRecord)record;
            ArrayList allAnswers = Lists.newArrayList(answers);
            if (verifiedAnswer != null) {
                allAnswers.add(verifiedAnswer);
            }
            Tokenizer tokenizer = Tokenizer.getTokenizer(((TokenizedTextLabelingTask)labelingTask).tokenizationParam);
            textRecord.setTokens(tokenizer.tokenizeWithInferredMechanism(textRecord.text, allAnswers));
        }
    }

    public List<String> listAnnotatorIds(AuthCtx authCtx, LabelingTask labelingTask) throws Exception {
        Dataset metadataDataset = this.labelingService.getMetadataDataset(labelingTask);
        return this.labelingInternalDBService.listAnnotatorIds(authCtx, labelingTask, metadataDataset);
    }

    public void importLabelingAnswers(List<BaseLabelingAnswer> answers) throws Exception {
        this.labelingInternalDBService.saveAnswers(answers);
    }
}

