/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling.score;

import com.dataiku.dip.labeling.ImageLabelingTask;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.classification.SimpleClassificationScoreComputer;
import com.dataiku.dip.labeling.entityextraction.SimpleNamedEntityExtractionScoreComputer;
import com.dataiku.dip.labeling.freetext.FreeTextScoreComputer;
import com.dataiku.dip.labeling.objectdetection.SimpleObjectDetectionScoreComputer;
import com.dataiku.dip.labeling.score.LabelingScoreComputer;
import com.dataiku.dip.utils.NotImplementedException;

public class LabelingScoreComputerFactory {
    public static LabelingScoreComputer<?, ?> getScoreComputer(LabelingTask task) {
        switch (task.type) {
            case OBJECT_DETECTION: {
                return new SimpleObjectDetectionScoreComputer(((ImageLabelingTask)task).objectDetectionIOUConflictThreshold);
            }
            case IMAGE_CLASSIFICATION: 
            case RECORD_CLASSIFICATION: 
            case TEXT_CLASSIFICATION: {
                return new SimpleClassificationScoreComputer();
            }
            case NAMED_ENTITY_EXTRACTION: {
                return new SimpleNamedEntityExtractionScoreComputer();
            }
            case RECORD_FREETEXT: {
                return new FreeTextScoreComputer();
            }
        }
        throw new NotImplementedException("Score computer not implemented for type " + String.valueOf((Object)task.type));
    }
}

