/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.license;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.license.License;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.license.LicenseUtils;
import com.dataiku.dip.license.LocalOnlyBackendLicenseStatusService;
import com.dataiku.dip.server.services.licensing.RemoteLicenseService;
import com.dataiku.dip.server.services.licensing.SAASInstanceService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import java.io.File;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackendLicenseStatusService
extends LocalOnlyBackendLicenseStatusService {
    private License cachedLicense;
    private long cachedTS;
    public static final long SAAS_LICENSE_CACHE_TIME = 3600000L;
    @Autowired
    private SAASInstanceService saasIService;
    @Autowired
    private RemoteLicenseService remoteLicenseService;
    private static Logger logger = Logger.getLogger((String)"dku.licensing");

    @PostConstruct
    public void start() {
        logger.debug((Object)"Init License service");
        switch (ApplicationConfigurator.getLicensingMode()) {
            case ON_PREMISE_CONNECTED: {
                new ConnectedRefreshThread().start();
                break;
            }
        }
        logger.debug((Object)"Done init License service");
    }

    protected synchronized void refreshLicenseNow() {
        try {
            License lic = this.remoteLicenseService.getLicense();
            JSON.prettyToFile((Object)lic, (File)ApplicationConfigurator.getFile((String)"config/license.json"));
            DKUFileUtils.forceDelete((File)ApplicationConfigurator.getFile((String)"config/license-status.txt"));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to refresh license", (Throwable)e);
            try {
                DKUFileUtils.writeFileUTF8((File)ApplicationConfigurator.getFile((String)"config/license-status.txt"), (String)("Failed to refresh license : " + e.getMessage()));
            }
            catch (Exception e2) {
                logger.error((Object)"And also failed to report it", (Throwable)e);
            }
        }
    }

    public synchronized LicenseStatusService.LicensingStatus getLicensingStatus() {
        switch (ApplicationConfigurator.getLicensingMode()) {
            case NONE: {
                throw new Error("unreachable");
            }
            case SAAS: {
                return this.getSAAS();
            }
            case ON_PREMISE_CONNECTED: {
                return this.getConnected();
            }
            case ON_PREMISE_DISCONNECTED: {
                return this.getLocalFile();
            }
        }
        throw new Error();
    }

    private LicenseStatusService.LicensingStatus getSAAS() {
        LicenseStatusService.LicensingStatus ls = new LicenseStatusService.LicensingStatus();
        if (this.cachedLicense == null || System.currentTimeMillis() - this.cachedTS > 3600000L) {
            logger.info((Object)"Need to refresh cached license status");
            try {
                this.cachedLicense = this.saasIService.getLicense();
                this.cachedTS = System.currentTimeMillis();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to get license from SAAS Service", (Throwable)e);
                ls.hasLicense = false;
                ls.invalidMessage = "Failed to retrieve license details. Please contact Dataiku.";
                return ls;
            }
        }
        try {
            LicenseUtils.verify((License)this.cachedLicense);
            ls.valid = true;
        }
        catch (Exception e) {
            logger.info((Object)"Validation failed", (Throwable)e);
            ls.invalidMessage = e.getMessage();
            return ls;
        }
        ls.licenseContent = (License.Content)JSON.deepCopy((Object)this.cachedLicense.content);
        ls.sublicense = this.cachedLicense.sublicense;
        ls.properties = ls.licenseContent.properties != null ? new Params(ls.licenseContent.properties) : new Params();
        this.checkExpiration(ls);
        if (ls.expired) {
            this.cachedLicense = null;
        }
        return ls;
    }

    private LicenseStatusService.LicensingStatus getConnected() {
        File statusFile;
        LicenseStatusService.LicensingStatus ls = new LicenseStatusService.LicensingStatus();
        File f = new File(ApplicationConfigurator.getBaseFolderF(), "config/license.json");
        if (!f.isFile()) {
            this.refreshLicenseNow();
        }
        if ((statusFile = new File(ApplicationConfigurator.getBaseFolderF(), "config/license-status.txt")).exists()) {
            try {
                ls.refreshStatusMessage = DKUFileUtils.readFileToStringUTF8((File)statusFile);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to read status message", (Throwable)e);
            }
        }
        if (!f.isFile()) {
            ls.invalidMessage = "This Studio does not have a license.";
            return ls;
        }
        long ts = f.lastModified();
        if (ts != this.cachedTS) {
            try {
                this.cachedLicense = (License)JSON.parseFile((File)f, License.class);
                this.cachedTS = ts;
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to read license file", (Throwable)e);
                ls.invalidMessage = "Failed to parse license file. Please check logs.";
                return ls;
            }
        }
        try {
            LicenseUtils.verify((License)this.cachedLicense);
            ls.valid = true;
        }
        catch (Exception e) {
            logger.info((Object)"Validation failed", (Throwable)e);
            ls.invalidMessage = e.getMessage();
            return ls;
        }
        ls.licenseContent = (License.Content)JSON.deepCopy((Object)this.cachedLicense.content);
        ls.sublicense = this.cachedLicense.sublicense;
        ls.properties = ls.licenseContent.properties != null ? new Params(ls.licenseContent.properties) : new Params();
        this.checkExpiration(ls);
        this.checkNodeLocking(ls);
        return ls;
    }

    class ConnectedRefreshThread
    extends Thread {
        ConnectedRefreshThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    LicenseStatusService.LicensingStatus ls = BackendLicenseStatusService.this.getLicensingStatus();
                    long refreshIfExpiresBefore = System.currentTimeMillis() + 1296000000L;
                    if (!ls.valid || ls.expired || ls.expiresOn > 0L && ls.expiresOn < refreshIfExpiresBefore) {
                        logger.info((Object)"Need to refresh the license");
                        BackendLicenseStatusService.this.refreshLicenseNow();
                    } else {
                        logger.info((Object)"Don't need to refresh the license");
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Refresh thread error", (Throwable)e);
                }
                DKUtils.unsafeSleep((long)60000L);
            }
        }
    }
}

