/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online;

import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.online.LLMChatMessageUtils;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class LLMTracingUtils {
    public static void addLLMIdentifiers(LLMClient.LLMMeshTraceObservation observation, String llmId, LLMClient llmClient) {
        observation.attributes.addProperty("llmId", llmId);
        try {
            EnrichedLLMStructuredRef ref;
            if (llmClient != null && (ref = llmClient.getEnrichedRef()) != null && ref.type != null) {
                observation.attributes.addProperty("llmProvider", ref.type.toString());
                observation.attributes.addProperty("llmModel", ref.getModelNameForAudit());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setCompletionInput(LLMClient.LLMMeshTraceSpan span, LLMClient.SingleCompletionQuery query, LLMClient.CompletionSettings settings) {
        span.setCompletionLLMInput(query);
        span.attributes.add("completionQuery", (JsonElement)LLMChatMessageUtils.completionQueryToLightJsonObject(query));
        span.attributes.add("completionQuerySettings", (JsonElement)JSON.toJsonObject((Object)settings));
    }

    public static void addIdentifiersAndSetCompletionInput(LLMClient.LLMMeshTraceSpan span, String llmId, LLMClient client, LLMClient.SingleCompletionQuery query, LLMClient.CompletionSettings settings) {
        LLMTracingUtils.addLLMIdentifiers(span, llmId, client);
        LLMTracingUtils.setCompletionInput(span, query, settings);
    }

    public static void setEmbeddingInput(LLMClient.LLMMeshTraceSpan span, LLMClient.EmbeddingQuery query, LLMClient.EmbeddingSettings settings) {
        span.setEmbeddingLLMInput(query);
        span.attributes.add("embeddingQuery", (JsonElement)LLMChatMessageUtils.embeddingQueryToLightJsonObject(query));
        span.attributes.add("embeddingQuerySettings", (JsonElement)JSON.toJsonObject((Object)settings));
    }

    public static void setRerankingInput(LLMClient.LLMMeshTraceSpan span, LLMClient.RerankingQuery query, LLMClient.RerankingSettings settings) {
        span.setRerankingLLMInput(query);
        span.attributes.add("rerankingQuery", (JsonElement)LLMChatMessageUtils.rerankingQueryToLightJsonObject(query));
        span.attributes.add("rerankingQuerySettings", (JsonElement)JSON.toJsonObject((Object)settings));
    }

    public static void setCompletionOutput(LLMClient.LLMMeshTraceSpan span, LLMClient.SimpleCompletionResponseOrError r) {
        span.setLLMOutput(r);
        JsonObject completionResponseJO = JSON.toJsonObject((Object)r);
        if (completionResponseJO.has("trace")) {
            completionResponseJO.remove("trace");
        }
        span.attributes.add("completionResponse", (JsonElement)completionResponseJO);
    }

    public static void addUsageMetadataAndSetCompletionOutput(LLMClient.LLMMeshTraceSpan span, LLMClient.SimpleCompletionResponseOrError r) {
        LLMTracingUtils.setCompletionOutput(span, r);
        span.usageMetadata = new LLMClient.UsageMetadata(r);
    }

    public static void setEmbeddingOutput(LLMClient.LLMMeshTraceSpan span, LLMClient.SimpleEmbeddingResponseOrError result) {
        span.attributes.add("embeddingResponse", (JsonElement)JF.obj().with("ok", Boolean.valueOf(result.ok)).with("promptTokens", (Number)result.promptTokens).with("tokenCountsAreEstimated", result.tokenCountsAreEstimated).with("estimatedCost", (Number)result.estimatedCost).with("additionalInformation", (JsonElement)result.additionalInformation).get());
    }

    public static void setRerankingOutput(LLMClient.LLMMeshTraceSpan span, LLMClient.SingleRerankingResponseOrError result) {
        span.attributes.add("rerankingResponse", (JsonElement)JF.obj().with("ok", Boolean.valueOf(result.ok)).with("estimatedCost", (Number)result.estimatedCost).get());
    }

    public static void addUsageMetadataAndSetEmbeddingOutput(LLMClient.LLMMeshTraceSpan span, LLMClient.SimpleEmbeddingResponseOrError r) {
        LLMTracingUtils.setEmbeddingOutput(span, r);
        span.usageMetadata = new LLMClient.UsageMetadata(r);
    }

    public static void addUsageMetadataAndSetRerankingOutput(LLMClient.LLMMeshTraceSpan span, LLMClient.SingleRerankingResponseOrError r) {
        LLMTracingUtils.setRerankingOutput(span, r);
        span.usageMetadata = new LLMClient.UsageMetadata(r);
    }
}

