/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.marshall;

import com.dataiku.dip.llm.online.LLMClient;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

public class LogProbsResponseAdapter {
    private LogProbsResponseAdapter() {
    }

    public static List<LLMClient.DetailedLogProb> adapt(List<String> tokens, List<Double> tokenLogProbs, @Nullable List<Map<String, Double>> topLogProbs) {
        if (tokens.size() != tokenLogProbs.size()) {
            throw new IllegalArgumentException(String.format("Inconsistent log probs: %d tokens vs %d logprobs", tokens.size(), tokenLogProbs.size()));
        }
        if (topLogProbs != null && topLogProbs.size() != tokens.size()) {
            throw new IllegalArgumentException(String.format("Inconsistent top log probs: %d tokens vs %d top logprobs", tokens.size(), topLogProbs.size()));
        }
        return IntStream.range(0, tokens.size()).mapToObj(i -> LogProbsResponseAdapter.adapt((String)tokens.get(i), (Double)tokenLogProbs.get(i), topLogProbs == null ? null : (Map)topLogProbs.get(i))).collect(Collectors.toList());
    }

    private static LLMClient.DetailedLogProb adapt(String token, Double logProb, @Nullable Map<String, Double> topLogProbs) {
        LLMClient.DetailedLogProb dlp = new LLMClient.DetailedLogProb();
        dlp.token = token;
        dlp.logProb = logProb;
        if (topLogProbs != null) {
            dlp.topLogProbs = topLogProbs.entrySet().stream().map(entry -> {
                LLMClient.SimpleLogProb slp = new LLMClient.SimpleLogProb();
                slp.token = (String)entry.getKey();
                slp.logProb = (Double)entry.getValue();
                return slp;
            }).collect(Collectors.toList());
        }
        return dlp;
    }
}

