/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.retrieval;

import com.dataiku.dip.code.PythonCodeEnvPackagesUtils;
import com.dataiku.dip.connections.PineconeConnection;

public class KnowledgeBankCodeEnvCompatibilityComputer {
    public static PythonCodeEnvPackagesUtils.CompatibilityInfo isEnvCompatibleWithConnection(PineconeConnection connection, PythonCodeEnvPackagesUtils.PythonEnvPackages envInfo) {
        PythonCodeEnvPackagesUtils.CompatibilityInfo info = new PythonCodeEnvPackagesUtils.CompatibilityInfo("Pinecone");
        info.compatible = true;
        if (envInfo == null) {
            info.compatible = false;
            info.reasons.add("The pinecone python package is not present in the Dataiku base python environment. Please select an env containing this package.");
            return info;
        }
        if (!envInfo.hasPackage("pinecone") && !envInfo.hasPackage("pinecone-client")) {
            info.compatible = false;
            info.reasons.add("The pinecone python package is not present in code env \"" + envInfo.envName + "\". Please select a different environment.");
            return info;
        }
        if (PineconeConnection.PineconeApiVersion.POST_APRIL_2024 != connection.params.version) {
            return info;
        }
        PythonCodeEnvPackagesUtils.PythonPackageVersion version = envInfo.getPackageVersion("pinecone-client");
        if (version != null && version.lt(PythonCodeEnvPackagesUtils.PythonPackageVersion.fromString("3.0.0"))) {
            info.compatible = false;
            info.reasons.add("The selected code env contains a pinecone-client package version less than 3.0.0. This is only supported with legacy pinecone connections");
        }
        return info;
    }
}

