/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.retrieval;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.exec.CodeBasedRecipeDatasetInfoHelper;
import com.dataiku.dip.io.JavaBlockLink;
import com.dataiku.dip.io.LocalSimplePythonKernel;
import com.dataiku.dip.llm.retrieval.KnowledgeBankCodes;
import com.dataiku.dip.llm.retrieval.KnowledgeBankManagementService;
import com.dataiku.dip.llm.retrieval.RAGKernelPool;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.TarArchiveUtils;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeBankDataService {
    @Autowired
    private KnowledgeBankManagementService kbMgmtService;
    @Autowired
    private RAGKernelPool ragKernelPool;
    @Autowired
    private NeverBuiltComputablesCacheService neverBuiltComputablesCacheService;
    private static final FilenameFilter KB_FILENAME_FILTER = (dir, name) -> !Set.of("kb.json", "recipe_settings.json", "version_info.json").contains(name);
    private static final Logger logger = Logger.getLogger((String)"dku.knowledgebank.data");

    public InfoMessage.InfoMessages clear_NT(AuthCtx authCtx, RetrievableKnowledge kb, String projectKey) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        ClearResult result = new ClearResult(kb);
        String version = this.kbMgmtService.getCurrentlyUsedVersion(kb);
        if ("not-built".equals(version)) {
            return new InfoMessage.InfoMessages().withSuccess((InfoMessage.MessageCode)KnowledgeBankCodes.INFO_KNOWLEDGE_BANK_CLEAR_OK, "Knowledge Bank not built, nothing to clear");
        }
        this.kbMgmtService.writeKnowledgeBankFolder(kb, version, folder -> {
            if (!folder.exists()) {
                result.withError(KnowledgeBankCodes.ERROR_KNOWLEDGE_BANK_CLEAR_FAILED, "Knowledge Bank folder does not exist");
                return;
            }
            File kbFile = DKUApp.getFile((File)folder, (String[])new String[]{"kb.json"});
            if (kbFile.exists()) {
                result.kb = (RetrievableKnowledge)JSON.parseFile((File)kbFile, RetrievableKnowledge.class);
                result.kb.id = kb.getId();
                result.kb.projectKey = kb.getProjectKey();
            }
            InfoMessage.InfoMessages info = KnowledgeBankDataService.clearInPythonKernel(authCtx, projectKey, result.kb, folder);
            result.withMessages(info);
        });
        if (result.success) {
            this.ragKernelPool.clearKernels(result.kb);
        }
        return new InfoMessage.InfoMessages().withMessages((InfoMessage.InfoMessages)result);
    }

    private static InfoMessage.InfoMessages clearInPythonKernel(AuthCtx authCtx, String projectKey, RetrievableKnowledge kb, File kbFolder) throws IOException {
        String envName = new CodeEnvSelector().selectForPythonRecipe(projectKey, kb.getCodeEnvSelection());
        InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
        try (LocalSimplePythonKernel kernel = new LocalSimplePythonKernel(authCtx, projectKey, GeneralSettingsDAO.CGrouppableProcessType.ML_KERNEL, envName, "dataiku.llm.rag.vector_store_clear_server", false, false, null, false, "vector-store-clear");){
            HashMap<String, String> extraEnv = new HashMap<String, String>();
            if (!Strings.isNullOrEmpty((String)kb.connection)) {
                extraEnv.put("DKU_KB_CONNECTION_INFO", JSON.json((Object)new CodeBasedRecipeDatasetInfoHelper().getConnectionInfoUnsafe_NT(authCtx, kb.connection, projectKey)));
            }
            kernel.withExtraEnv(extraEnv);
            JavaBlockLink link = kernel.getLink();
            kernel.start();
            ClearCommand command = new ClearCommand();
            command.projectKey = projectKey;
            command.retrievableKnowledge = kb;
            command.folderPath = kbFolder.getAbsolutePath();
            link.sendRequest((Object)command);
            JsonObject result = (JsonObject)link.receiveJsonResponse(JsonObject.class);
            logger.info((Object)("Clearing result: " + String.valueOf(result)));
            if (result.has("type") && "ERROR".equals(result.get("type").getAsString())) {
                infoMessages.withError((InfoMessage.MessageCode)KnowledgeBankCodes.ERROR_KNOWLEDGE_BANK_CLEAR_FAILED, "Knowledge Bank clear failed: " + JSON.json((Object)result));
            } else {
                infoMessages.withSuccess((InfoMessage.MessageCode)KnowledgeBankCodes.INFO_KNOWLEDGE_BANK_CLEAR_OK, "Knowledge Bank cleared successfully");
            }
        }
        catch (Exception e) {
            infoMessages.withError((InfoMessage.MessageCode)KnowledgeBankCodes.ERROR_KNOWLEDGE_BANK_CLEAR_FAILED, "Knowledge Bank clear failed: " + String.valueOf(e));
        }
        return infoMessages;
    }

    public String createNewVersion_NT(RetrievableKnowledge rk, InputStream is) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        String version = Long.toString(System.currentTimeMillis());
        File targetFolder = RetrievableKnowledgeUtils.getVersionFolder(rk, version);
        try (AutoDelete sandboxFolder = KnowledgeBankDataService.getTemporaryFolder(rk);){
            File versionTmpFolder = DKUApp.getFile((File)sandboxFolder, (String[])new String[]{version});
            try {
                DKUFileUtils.mkdirs((File)versionTmpFolder);
                TarArchiveUtils.extractTarGzInputStream(is, KB_FILENAME_FILTER, versionTmpFolder);
            }
            catch (IOException e) {
                throw new IOException(String.format("Cannot extract .tar.gz input stream for knowledge bank %s", rk.getFullId()), e);
            }
            RetrievableKnowledge.RetrievableKnowledgeVersionInfo versionDesc = new RetrievableKnowledge.RetrievableKnowledgeVersionInfo();
            versionDesc.buildAt = System.currentTimeMillis();
            File infoFile = DKUApp.getFile((File)versionTmpFolder, (String[])new String[]{"version_info.json"});
            JSON.prettyToFile((Object)versionDesc, (File)infoFile);
            File kbFile = DKUApp.getFile((File)versionTmpFolder, (String[])new String[]{"kb.json"});
            JSON.prettyToFile((Object)rk, (File)kbFile);
            DKUFileUtils.mkdirsParent((File)targetFolder);
            Files.move(versionTmpFolder.toPath(), targetFolder.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        RetrievableKnowledge.RetrievableKnowledgeVersions versionsDesc = new RetrievableKnowledge.RetrievableKnowledgeVersions();
        versionsDesc.currentVersion = version;
        File dataFolder = RetrievableKnowledgeUtils.getDataFolder(rk.projectKey, rk.id);
        File versionsFile = DKUApp.getFile((File)dataFolder, (String[])new String[]{"versions.json"});
        JSON.prettyToFile((Object)versionsDesc, (File)versionsFile);
        this.neverBuiltComputablesCacheService.remove(new TaggableObjectsService.TaggableObjectRef(rk));
        return version;
    }

    private static AutoDelete getTemporaryFolder(RetrievableKnowledge rk) throws IOException {
        String folderName = String.format("%s-%s", rk.getId(), SecretKeyGenerator.generate((int)8));
        return DSSTempUtils.getTempFolder((String)"knowledge-bank-version", (String)folderName);
    }

    private static class ClearResult
    extends InfoMessage.InfoMessages {
        RetrievableKnowledge kb;

        public ClearResult(RetrievableKnowledge kb) {
            this.kb = kb;
        }
    }

    private static class ClearCommand {
        public String projectKey;
        public RetrievableKnowledge retrievableKnowledge;
        public String folderPath;

        private ClearCommand() {
        }
    }
}

