/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.checks;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.util.DatasetLocUtils;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class DatasetCheckContext
extends AbstractCheckContext {
    public final Dataset dataset;
    public final Partition partition;
    List<MetricsComputationService.ValuedMetric> computedMetrics;
    public Map<String, Map<String, List<ReadOnlyJobsInternalDB.MetricDataPoint>>> lastValuesPerDataset = Maps.newHashMap();
    public final long metricsComputationTime;

    public DatasetCheckContext(Dataset dataset, Partition partition, long timeCheck, ReadWriteJobsInternalDB jobsDatabaseService, APITicketService.Ticket ticket, String projectKey, List<MetricsComputationService.ValuedMetric> computedMetrics, long metricsComputationTime) {
        super(timeCheck, jobsDatabaseService, ticket, projectKey);
        this.dataset = dataset;
        this.partition = partition;
        this.computedMetrics = computedMetrics;
        this.metricsComputationTime = metricsComputationTime;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public Partition getPartition() {
        return this.partition;
    }

    @Override
    public void ensureLastValues() throws Exception {
        if (this.lastValues == null) {
            this.lastValues = Maps.newHashMap();
            for (ReadOnlyJobsInternalDB.MetricDataPoint computed : this.jobsDatabaseService.getLastMetrics(this.dataset.getLoc(), this.partition == null ? null : this.partition.id())) {
                this.lastValues.put(computed.metric.getId(), computed);
            }
            for (MetricsComputationService.ValuedMetric value : this.computedMetrics) {
                this.lastValues.put(value.metricId, new ReadOnlyJobsInternalDB.MetricDataPoint(value.metric, this.getProjectKey(), this.dataset.getName(), this.metricsComputationTime, value.value, value.dataType, this.partition != null ? this.partition.id() : null, null));
            }
        }
    }

    @Override
    public List<ReadOnlyJobsInternalDB.MetricDataPoint> getHistory(String metricId) throws Exception {
        return this.jobsDatabaseService.getMetrics(this.dataset.getLoc(), this.partition == null ? null : this.partition.id(), metricId);
    }

    @Override
    public AbstractCheckContext.CheckParameters setParamsForPythonChecks() throws Exception {
        String partitionId = this.getPartition() != null ? this.getPartition().id() : "NP";
        String fullName = this.getDataset().getFullName();
        MetricTargetType objectType = MetricTargetType.DATASET;
        return new AbstractCheckContext.CheckParameters(objectType, partitionId, fullName);
    }

    @Nullable
    public ReadOnlyJobsInternalDB.MetricDataPoint getCurrentValueDifferentDataset(String datasetName, String metricId, String partition) throws Exception {
        List<ReadOnlyJobsInternalDB.MetricDataPoint> dataPoints = this.ensureLastValuesDifferentDataset(datasetName, metricId);
        if (partition == null) {
            return dataPoints.stream().max(Comparator.comparing(a -> a.time)).orElse(null);
        }
        return dataPoints.stream().filter(pt -> StringUtils.equals((CharSequence)partition, (CharSequence)pt.partition)).findFirst().orElse(null);
    }

    private List<ReadOnlyJobsInternalDB.MetricDataPoint> ensureLastValuesDifferentDataset(String datasetName, String metricId) throws Exception {
        Map datasetMap = this.lastValuesPerDataset.computeIfAbsent(datasetName, k -> new HashMap());
        if (!datasetMap.containsKey(metricId)) {
            datasetMap.put(metricId, this.jobsDatabaseService.getLastMetricValues(new DatasetLocUtils.DatasetLoc(this.getProjectKey(), datasetName), metricId));
        }
        return (List)datasetMap.get(metricId);
    }

    public void browseRecentMetricData(String metricId, Predicate<ReadOnlyJobsInternalDB.MetricDataPoint> handle) throws Exception {
        this.jobsDatabaseService.browseRecentMetricData(this.dataset.getLoc(), this.partition == null ? null : this.partition.id(), metricId, handle);
    }
}

