/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.checks;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.AbstractPythonCheck;
import com.dataiku.dip.metrics.checks.Check;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class PythonCheck
extends AbstractPythonCheck.AbstractPolyJsonablePythonCheck
implements MetaWithSelectableCodeEnv,
ParamsWithSelectableCodeEnv {
    public static final String TYPE = "python";
    public String code;
    public CodeEnvSelection envSelection = new CodeEnvSelection();

    public PythonCheck() {
        this.type = TYPE;
        this.meta.withName("Custom check");
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    protected PluginSettingsResolver.ResolvedSettings getPluginConfig(AuthCtx authCtx, String projectKey) {
        return new PluginSettingsResolver.ResolvedSettings(null, null);
    }

    @Override
    public AbstractCheckContext.CheckResult run(AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        return this.doRun(authCtx, context, runReport);
    }

    @Override
    public Check trimForSave() {
        return this;
    }

    @Override
    public String getLegacyDatabaseId() {
        Object label;
        if (this.meta != null && !StringUtils.isBlank((String)this.meta.getLabel())) {
            return this.meta.getLabel();
        }
        Object object = label = this.meta != null ? this.meta.getName() : null;
        if (StringUtils.isBlank((String)label)) {
            String codeHash = DigestUtils.md5Hex((String)this.getCode());
            label = this.getType() + "_h" + codeHash;
        }
        return label;
    }

    @Override
    protected String getEnvName(String projectKey) throws IOException {
        CodeEnvSelector envSelector = new CodeEnvSelector();
        return envSelector.selectForPythonRecipe(projectKey, this.envSelection);
    }

    @Override
    public CodeEnvSelection getCodeEnvSelection() {
        return this.envSelection;
    }

    @Override
    public void setCodeEnvSelection(CodeEnvSelection envSelection) {
        this.envSelection = envSelection;
    }

    @Override
    protected String getResourceFolder() {
        return null;
    }

    @Override
    protected String getLibFolder() {
        return null;
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
        ArrayList usages = Lists.newArrayList();
        if (this.envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
            usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, this.envSelection.envName, CodeEnvModel.EnvUsage.DATASET_CHECK, object.getProjectKey(), object.getId()));
        }
        return usages;
    }

    @Override
    public CodeEnvModel.EnvLang getEnvLang() {
        return CodeEnvModel.EnvLang.PYTHON;
    }

    @Override
    public RuleValidationError verifyConfig(Dataset dataset) {
        return null;
    }

    @Override
    public RuleValidationError verifyPreConditions(Dataset dataset, List<MetricsComputationService.ValuedMetric> computedMetrics) {
        return null;
    }
}

