/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.HiveServer2ConnectionPoolService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.engines.ColumnMetricsQueryBuilder;
import com.dataiku.dip.metrics.engines.JdbcEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.recipes.code.hive.HiveConfHelper;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class HiveColumnMetricsEngine
extends JdbcEngine
implements ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderEngine {
    @Autowired
    private HiveServer2ConnectionPoolService hiveServer2ConnectionPoolService;
    private final JdbcEngine.HiveMetricsEngineConfig config;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.hive.column_metrics");

    public HiveColumnMetricsEngine(Dataset dataset, Partition partition, JdbcEngine.HiveMetricsEngineConfig config) {
        super(dataset, partition);
        this.config = config;
    }

    @Override
    public void setupConnection(AuthCtx authCtx) throws IOException, DKUSecurityException {
        String database = HiveSchemaHandler.getResolvedHiveDatabaseFromDataset(this.dataset);
        logger.info((Object)("Hive metrics engine on database : " + database));
        List<SimpleKeyValue> hiveconf = new HiveConfHelper().getResolvedHiveRuntimeConf(authCtx, this.dataset.getProjectKey(), this.config.extraConf);
        HiveConnection datasetConnection = HiveConfigurator.configureConnectionForDatabase(authCtx, database == null ? "" : database, hiveconf, this.hiveServer2ConnectionPoolService);
        this.connectionData = datasetConnection.getConnectionData_NT(authCtx, this.dataset.getProjectKey());
        this.dialect = this.connectionData.getDialect();
    }

    @Override
    public QueryBunch buildQuery(AuthCtx authCtx, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
        ColumnMetricsQueryBuilder builder = new ColumnMetricsQueryBuilder();
        return builder.buildQuery(authCtx, this, computations);
    }

    @Override
    public Map<Metric, String> getAggregates(QueryRunResult res, List<MetricComputation> computations) throws Exception {
        for (String[] row : res.rows) {
            boolean more = false;
            for (MetricComputation computation : computations) {
                ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation computer = (ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation)((Object)computation.computer);
                more |= computer.handleResult(res.columns, row, computation);
            }
            if (more) continue;
            break;
        }
        HashMap metricsValues = Maps.newHashMap();
        for (int i = 0; i < computations.size(); ++i) {
            MetricComputation computation = computations.get(i);
            ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation computer = (ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation)((Object)computation.computer);
            metricsValues.put(computation.metric, computer.getAggregate(computation));
        }
        return metricsValues;
    }

    public static class HiveColumnMetricsEngineRun
    extends MetricsEngineRun {
        public final String column;

        public HiveColumnMetricsEngineRun(String column) {
            super(MetricsEngineDesc.HiveColumnMetricsEngine);
            this.column = column;
        }

        public HiveColumnMetricsEngineRun(String column, double cost, List<MetricComputation> computations, int pass) {
            super(MetricsEngineDesc.HiveColumnMetricsEngine, cost, computations, pass);
            this.column = column;
        }

        @Override
        protected MetricsEngineRun subset(double cost, List<MetricComputation> computations) {
            return new HiveColumnMetricsEngineRun(this.column, cost, computations, this.pass);
        }

        @Override
        public boolean canMergeWith(MetricsEngineRun other) {
            return super.canMergeWith(other) && this.column.equals(((HiveColumnMetricsEngineRun)other).column);
        }
    }
}

