/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class AgentEvaluationProbeType
extends ProbeType {
    public static final String TYPE = "agent_evaluation";
    private static final Map<AgentEvaluationMetricsEnum, MetricMetadata> metadataPerType = Maps.newHashMap();

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        return Lists.newArrayList();
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        return Lists.newArrayList();
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> column, Probe probe) {
        return null;
    }

    @Override
    public ProbeType trimForSave() {
        return new AgentEvaluationProbeType();
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return AgentEvaluationProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        return new ProbeMetadata().withLevel(0).withName("Agent Evaluation");
    }

    @Override
    public boolean isUserSelectedProbe() {
        return false;
    }

    static {
        for (AgentEvaluationMetricsEnum metric : AgentEvaluationMetricsEnum.values()) {
            metadataPerType.put(metric, new MetricMetadata().withName(metric.displayName).withFormat("longReadableNumber"));
        }
    }

    public static class AgentEvaluationProbeConfiguration
    implements ProbeConfiguration {
    }

    public static enum AgentEvaluationMetricsEnum {
        AVERAGE_TOOL_EXECUTIONS_PER_ROW("Tool calls"),
        AVERAGE_FAILED_TOOL_EXECUTIONS_PER_ROW("Failed tool calls"),
        AVERAGE_TOOL_EXECUTION_TIME_SECONDS_PER_ROW("Tool calls execution time (s)"),
        P95_TOTAL_AGENT_CALL_EXECUTION_TIME_SECONDS_PER_ROW("Total agent call execution time (s)"),
        SAMPLE_ROW_COUNT("Sample row count"),
        TOOL_CALL_EXACT_MATCH("Tool calls - Exact Match"),
        TOOL_CALL_PARTIAL_MATCH("Tool calls - Partial Match"),
        TOOL_CALL_PRECISION("Tool calls - Precision"),
        TOOL_CALL_RECALL("Tool calls - Recall"),
        TOOL_CALL_F1("Tool calls - F1 Score"),
        AGENT_GOAL_ACCURACY_WITH_REFERENCE("Agent Goal Accuracy with reference"),
        AGENT_GOAL_ACCURACY_WITHOUT_REFERENCE("Agent Goal Accuracy without reference"),
        ANSWER_SIMILARITY("Answer similarity"),
        ANSWER_CORRECTNESS("Answer correctness"),
        BERT_SCORE_PRECISION("BERT Score - Precision"),
        BERT_SCORE_RECALL("BERT Score - Recall"),
        BERT_SCORE_F1("BERT Score - F1 Score");

        final String displayName;

        private AgentEvaluationMetricsEnum(String displayName) {
            this.displayName = displayName;
        }
    }

    public static class AgentEvaluationMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof AgentEvaluationMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            AgentEvaluationMetric agentEvaluationMetric = (AgentEvaluationMetric)metric;
            return Metric.buildMetricIdFromParts(AgentEvaluationProbeType.TYPE, agentEvaluationMetric.metricType.name());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.get(0).equals(AgentEvaluationProbeType.TYPE)) {
                AgentEvaluationMetricsEnum metricType = AgentEvaluationMetricsEnum.valueOf(parts.get(1));
                return new AgentEvaluationMetric(metricType);
            }
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
        }
    }

    @UIModel
    public static class AgentEvaluationMetric
    extends Metric {
        public AgentEvaluationMetricsEnum metricType;

        public AgentEvaluationMetric(AgentEvaluationMetricsEnum metricType) {
            super(AgentEvaluationProbeType.TYPE, Type.DOUBLE);
            this.metricType = metricType;
            this.id = Metric.serializeMetric(this);
        }

        @Override
        public MetricMetadata getMeta() {
            return metadataPerType.get((Object)this.metricType);
        }

        @Override
        public String getColumn() {
            return null;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return this.getId();
        }

        @Override
        @Nullable
        public Probe getMatchingProbe(List<Probe> probes) {
            return new Probe(this.getType()).withConfiguration(new AgentEvaluationProbeConfiguration()).withMeta(ProbeType.getProbeType(AgentEvaluationProbeType.TYPE).getMeta());
        }
    }
}

