/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.nodeclients;

import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.deployments.MultiNodeProjectDeploymentManager;
import com.dataiku.dip.apideployer.deployments.SingleNodeProjectDeploymentManager;
import com.dataiku.dip.apideployer.engine.DeploymentReport;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.nodeclients.AbstractDeployerClientProxyUser;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.entity.ContentType;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.HttpMultipartMode;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.MultipartEntityBuilder;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.ContentBody;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.FileBody;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.StringBody;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ProjectDeployerClientProxyUser
extends AbstractDeployerClientProxyUser {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.nodeclients.projectdeployer.proxyuser");

    public ProjectDeployerClientProxyUser(GeneralSettingsDAO.DeployerRef ref, AuthCtx authCtx) {
        super(ref, authCtx);
    }

    @Override
    protected String getPublicBaseUrl() {
        return "public/api/project-deployer/";
    }

    @Override
    protected String getPublicPublishedItemUrl(String publishedProjectKey) {
        return this.getPublicBaseUrl() + "projects/" + publishedProjectKey;
    }

    @Override
    AbstractPublishedItemLightStatus.PublishedProjectLightStatus getPublishedItemLightStatus(AbstractDeployment deployment) throws IOException {
        String getLightStatusPath = this.getPublicPublishedItemUrl(deployment.getPublishedItemId());
        return (AbstractPublishedItemLightStatus.PublishedProjectLightStatus)this.getForm(getLightStatusPath, AbstractPublishedItemLightStatus.PublishedProjectLightStatus.class, new Object[0]);
    }

    public AbstractDeploymentLightStatus.ProjectDeploymentLightStatus getDeploymentLightStatus(String deploymentId) throws IOException {
        String path = this.getPublicBaseUrl() + "deployments/" + deploymentId;
        return (AbstractDeploymentLightStatus.ProjectDeploymentLightStatus)this.getForm(path, AbstractDeploymentLightStatus.ProjectDeploymentLightStatus.class, new Object[0]);
    }

    public List<AbstractPublishedItemLightStatus.PublishedProjectLightStatus> listPublishedProjectLightStatus() throws IOException {
        JsonArray unparsedLightStatusList = (JsonArray)this.getForm(this.getPublicBaseUrl() + "projects", JsonArray.class, new Object[0]);
        return (List)JSON.parse((JsonElement)unparsedLightStatusList, (TypeToken)new TypeToken<List<AbstractPublishedItemLightStatus.PublishedProjectLightStatus>>(){});
    }

    public List<AbstractDeploymentLightStatus.ProjectDeploymentLightStatus> listDeploymentLightStatus() throws IOException {
        JsonArray unparsedLightStatusList = (JsonArray)this.getForm(this.getPublicBaseUrl() + "deployments", JsonArray.class, new Object[0]);
        return (List)JSON.parse((JsonElement)unparsedLightStatusList, (TypeToken)new TypeToken<List<AbstractDeploymentLightStatus.ProjectDeploymentLightStatus>>(){});
    }

    public PublishedPackageInfo publishBundle(String projectKey, File bundleFile) throws IOException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        FileBody fileBody = new FileBody(bundleFile, ContentType.DEFAULT_BINARY);
        builder.addPart("file", (ContentBody)fileBody);
        builder.addPart("projectKey", (ContentBody)new StringBody(projectKey, ContentType.MULTIPART_FORM_DATA));
        HttpEntity entity = builder.build();
        return (PublishedPackageInfo)this.postAnyToJSON(this.getPublicBaseUrl() + "projects/bundles", PublishedPackageInfo.class, entity);
    }

    public FutureResponse<? extends DeploymentReport> updateDeployment(String deploymentId) throws IOException {
        AbstractDeployerClientProxyUser.DeploymentUpdateRequest dur = new AbstractDeployerClientProxyUser.DeploymentUpdateRequest();
        AbstractInfraBasicInfo infraBasicInfo = this.getDeploymentLightStatus((String)deploymentId).infraBasicInfo;
        if (infraBasicInfo instanceof AbstractInfraBasicInfo.SingleAutomationNodeInfraBasicInfo) {
            return super.updateDeployment(deploymentId, dur, new TypeToken<FutureResponse<SingleNodeProjectDeploymentManager.PreparePreloadAndActivateReport>>(){});
        }
        if (infraBasicInfo instanceof AbstractInfraBasicInfo.MultiAutomationNodeInfraBasicInfo) {
            return super.updateDeployment(deploymentId, dur, new TypeToken<FutureResponse<MultiNodeProjectDeploymentManager.MultiNodePreparePreloadAndActivateReport>>(){});
        }
        throw new IllegalArgumentException("Invalid infra type: " + JSON.getType((Object)infraBasicInfo));
    }

    @Override
    public String packageIdParameterName() {
        return "bundleId";
    }
}

