/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.RowNumberAwareOutputWriter;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.EditableDatasetService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.Header;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.client.entity.UrlEncodedFormEntity;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.conn.ClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.PoolingClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicHeader;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicNameValuePair;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ForwardToBackendOutputWriter
extends RowNumberAwareOutputWriter {
    private static PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
    private static DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)connectionManager);
    private ColumnFactory cf;
    private Schema schema;
    private Dataset dataset;
    private EditableDatasetService.EditableDatasetSaveQuery backendSaveQuery;
    static final DKULogger logger;

    public ForwardToBackendOutputWriter(Dataset dataset, Schema schema, Output.WriteMode wm) {
        this.dataset = dataset;
        this.schema = schema;
        this.backendSaveQuery = new EditableDatasetService.EditableDatasetSaveQuery();
        this.backendSaveQuery.versionTag = dataset.serialize().versionTag;
        this.backendSaveQuery.data = new ArrayList();
        this.backendSaveQuery.rowMapping = new ArrayList();
        this.backendSaveQuery.schema = schema;
        if (wm == Output.WriteMode.OVERWRITE) {
            this.backendSaveQuery.markChanged = false;
        }
    }

    public void init(ColumnFactory cf) throws IOException {
        this.cf = cf;
    }

    public void emitRow(Row row) throws Exception {
        this.emitRow(row, -1);
    }

    public void emitRow(Row row, int origIndex) throws Exception {
        ArrayList<String> line = new ArrayList<String>();
        for (SchemaColumn sc : this.schema.columns) {
            line.add(row.get(this.cf.column(sc.getName())));
        }
        this.backendSaveQuery.rowMapping.add(origIndex);
        this.backendSaveQuery.data.add(line);
    }

    public void lastRowEmitted() throws Exception {
        this.sendToBackend();
    }

    public void cancel() throws Exception {
    }

    public long writtenBytes() throws IOException {
        return -1L;
    }

    private void sendToBackend() throws Exception {
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        pairs.add(new BasicNameValuePair("dataset", this.dataset.getName()));
        pairs.add(new BasicNameValuePair("projectKey", this.dataset.getProjectKey()));
        pairs.add(new BasicNameValuePair("data", JSON.json((Object)this.backendSaveQuery)));
        int port = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
        HttpPost post = new HttpPost("http://127.0.0.1:" + port + "/dip/api/tintercom/datasets/editable/save");
        APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        try (APITicketService.TicketUsage ticket = apiTicketService.getAndUseSingleTicket();){
            post.setHeader((Header)new BasicHeader("X-DKU-APITicket", ticket.getTicket().getSecret()));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, "utf8"));
            CloseableHttpResponse forwardResp = client.execute((HttpUriRequest)post);
            String body = IOUtils.toString((InputStream)forwardResp.getEntity().getContent(), (String)"utf8");
            int code = forwardResp.getStatusLine().getStatusCode();
            if (code != 200) {
                throw new IOException("Error occurred in backend: " + body);
            }
        }
    }

    static {
        client.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        logger = DKULogger.getLogger((String)"dku.output.fwd");
    }
}

