/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.output.CountingOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class ResplitFilesOutputWriter
extends OutputWriter {
    private List<Split> splits = new ArrayList<Split>();
    private boolean headerEmitted;
    private ColumnFactory cf;
    int rows = 0;

    public ResplitFilesOutputWriter(AuthCtx authCtx, String projectKey, List<String> paths, String formatType, FormatParams formatParams, Schema schema, WarningsContext warningsContext) {
        for (String path : paths) {
            Split split = new Split();
            split.path = path;
            split.formatter = FormatFactory.buildFormatter(authCtx, projectKey, formatType, formatParams);
            if (schema != null) {
                split.formatter.setOutputSchema(schema);
            }
            if (warningsContext != null) {
                split.formatter.setWarningsContext(warningsContext);
            }
            this.splits.add(split);
        }
    }

    public void init(ColumnFactory cf) throws IOException {
        this.cf = cf;
        for (Split split : this.splits) {
            DKUFileUtils.mkdirsParent((File)new File(split.path));
            split.fos = new FileOutputStream(new File(split.path));
            if (split.path.contains(".gz")) {
                split.countingStream = new CountingOutputStream((OutputStream)split.fos);
                split.finalOutputStream = new GZIPOutputStream((OutputStream)split.countingStream);
                continue;
            }
            split.countingStream = new CountingOutputStream((OutputStream)split.fos);
            split.finalOutputStream = split.countingStream;
        }
    }

    public void emitRow(Row row) throws Exception {
        if (!this.headerEmitted) {
            for (Split split : this.splits) {
                split.formatter.header(this.cf, split.finalOutputStream);
            }
            this.headerEmitted = true;
        }
        int split = this.rows++ % this.splits.size();
        this.splits.get((int)split).formatter.format(row, this.cf, this.splits.get((int)split).finalOutputStream);
    }

    public void lastRowEmitted() throws Exception {
        for (Split split : this.splits) {
            split.formatter.footer(this.cf, split.finalOutputStream);
            split.finalOutputStream.close();
            split.fos.close();
        }
    }

    public void cancel() throws Exception {
        for (Split split : this.splits) {
            split.formatter.cancel(split.finalOutputStream);
            split.finalOutputStream.close();
            split.fos.close();
        }
    }

    public long writtenBytes() throws IOException {
        long r = 0L;
        for (Split split : this.splits) {
            r += split.countingStream.getByteCount();
        }
        return r;
    }

    static class Split {
        CountingOutputStream countingStream;
        OutputStream finalOutputStream;
        FileOutputStream fos;
        String path;
        OutputFormatter formatter;

        Split() {
        }
    }
}

