/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.datebinner;

import com.dataiku.dip.pivot.backend.common.datebinner.AbstractTimelineBinner;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dss.shadelib.org.joda.time.Chronology;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.chrono.GJChronology;

public class YearTimelineBinner
extends AbstractTimelineBinner {
    @Override
    public long getBinId(long timestamp) {
        return new DateTime(timestamp, (Chronology)GJChronology.getInstanceUTC()).getYear();
    }

    @Override
    public long getBinStartTimestamp(long binId) {
        return new DateTime(0L, (Chronology)GJChronology.getInstanceUTC()).withYear((int)binId).getMillis();
    }

    @Override
    public String getLabel(long binId) {
        return String.valueOf(binId);
    }

    @Override
    public long getBinIdFromSqlValue(long sqlValue) {
        return (int)sqlValue;
    }

    @Override
    DateRounding dateRounding() {
        throw new IllegalStateException("This method should never be called. Year behaves as 'group' types rather than 'timelines'.");
    }

    @Override
    String datePartExpression(String input, SQLDialect dialect) {
        return input;
    }

    @Override
    DatePart datePart() {
        return DatePart.YEAR;
    }

    @Override
    public boolean requireMaterializationForSqlEngine(boolean naturallyOrdered) {
        return !naturallyOrdered;
    }
}

