/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.pivot.backend.dss.aggregators.FlushableAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.FlushableAggregatorImpl;
import gnu.trove.iterator.TDoubleIterator;
import gnu.trove.set.hash.TDoubleHashSet;
import java.io.IOException;
import java.util.HashSet;

public class CountDistinctAggregatorImpl
extends FlushableAggregatorImpl<TDoubleHashSet, HashSet<String>> {
    public CountDistinctAggregatorImpl(double[] data, long[] nonNullCounts, String column, int passNumber) {
        super(data, nonNullCounts, column, passNumber);
    }

    public CountDistinctAggregatorImpl(double[] data, long[] nonNullCounts, String column) {
        super(data, nonNullCounts, column);
    }

    @Override
    public boolean handle(double value, int loc, boolean incrementNonNullCount) throws IOException {
        TDoubleHashSet tDoubleHash;
        boolean handled = super.handle(value, loc, incrementNonNullCount);
        if (handled && (tDoubleHash = this.doubleStore.computeIfAbsent(loc, x -> new TDoubleHashSet())).add(value)) {
            int n = loc;
            this.data[n] = this.data[n] + 1.0;
        }
        return handled;
    }

    @Override
    public boolean handle(double value, int loc) throws IOException {
        return this.handle(value, loc, true);
    }

    @Override
    public boolean handle(Object value, int loc, boolean incrementNonNullCount) throws IOException {
        HashSet hashSet;
        boolean handled = super.handle(value, loc, incrementNonNullCount);
        if (handled && (hashSet = this.stringStore.computeIfAbsent(loc, x -> new HashSet())).add(value.toString())) {
            int n = loc;
            this.data[n] = this.data[n] + 1.0;
        }
        return handled;
    }

    @Override
    public boolean handle(Object value, int loc) throws IOException {
        return this.handle(value, loc, true);
    }

    @Override
    public void readValues(int loc, FlushableAggregator.Visitor visitor) throws IOException {
        if (this.stringStore != null && !this.stringStore.isEmpty()) {
            HashSet values = (HashSet)this.stringStore.get(loc);
            if (values == null) {
                return;
            }
            visitor.beginRead(loc, values.size());
            for (String value : values) {
                visitor.handleString(value);
            }
            visitor.endRead(loc);
            return;
        }
        if (this.doubleStore != null && !this.doubleStore.isEmpty()) {
            TDoubleHashSet values = (TDoubleHashSet)this.doubleStore.get(loc);
            if (values == null) {
                return;
            }
            visitor.beginRead(loc, values.size());
            TDoubleIterator iterator = values.iterator();
            while (iterator.hasNext()) {
                visitor.handleDouble(iterator.next());
            }
            visitor.endRead(loc);
            return;
        }
        super.readValues(loc, visitor);
    }

    @Override
    public void handleString(String value) {
        if (this.stringValues == null) {
            this.stringValues = new HashSet();
            this.doubleValues = null;
        }
        ((HashSet)this.stringValues).add(value);
    }

    @Override
    public void handleDouble(double value) {
        if (this.doubleValues == null) {
            this.doubleValues = new TDoubleHashSet();
            this.stringValues = null;
        }
        ((TDoubleHashSet)this.doubleValues).add(value);
    }

    @Override
    public void endRead(int location) {
        if (this.doubleValues != null) {
            this.data[location] = ((TDoubleHashSet)this.doubleValues).size();
        } else if (this.stringValues != null) {
            this.data[location] = ((HashSet)this.stringValues).size();
        }
    }
}

