/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.pivot.backend.dss.aggregators.FlushableAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.FlushableAggregatorImpl;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.utils.NotImplementedException;
import gnu.trove.iterator.TDoubleIterator;
import gnu.trove.list.array.TDoubleArrayList;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;

public class PercentilesAggregatorImpl
extends FlushableAggregatorImpl<TDoubleArrayList, ArrayList<String>> {
    Aggregation aggregation;

    public PercentilesAggregatorImpl(Aggregation aggregation, double[] data, long[] nonNullCounts, String column, int passNumber) {
        super(data, nonNullCounts, column, passNumber);
        this.aggregation = aggregation;
    }

    public PercentilesAggregatorImpl(Aggregation aggregation, double[] data, long[] nonNullCounts, String column) {
        super(data, nonNullCounts, column);
        this.aggregation = aggregation;
    }

    @Override
    public boolean handle(double value, int loc, boolean incrementNonNullCount) throws IOException {
        boolean handled = super.handle(value, loc, incrementNonNullCount);
        if (handled) {
            TDoubleArrayList tDoubleArray = this.doubleStore.computeIfAbsent(loc, x -> new TDoubleArrayList());
            tDoubleArray.add(value);
            this.data[loc] = 1.0;
        }
        return handled;
    }

    @Override
    public boolean handle(double value, int loc) throws IOException {
        return this.handle(value, loc, true);
    }

    @Override
    public boolean handle(Object value, int loc, boolean incrementNonNullCount) throws IOException {
        throw new NotImplementedException("Cannot compute percentiles on non numeric values");
    }

    @Override
    public boolean handle(Object value, int loc) throws IOException {
        return this.handle(value, loc, true);
    }

    @Override
    public void onEnd(boolean storeLocation) throws IOException {
        super.onEnd(storeLocation);
        if (!this.hasBeenFlushed()) {
            this.doubleStore.forEach((key, value) -> {
                this.data[key.intValue()] = this.computePercentile((TDoubleArrayList)value);
            });
        }
    }

    @Override
    public void readValues(int loc, FlushableAggregator.Visitor visitor) throws IOException {
        if (this.doubleStore != null && !this.doubleStore.isEmpty()) {
            TDoubleArrayList values = (TDoubleArrayList)this.doubleStore.get(loc);
            if (values == null) {
                return;
            }
            visitor.beginRead(loc, values.size());
            TDoubleIterator iterator = values.iterator();
            while (iterator.hasNext()) {
                visitor.handleDouble(iterator.next());
            }
            visitor.endRead(loc);
            return;
        }
        super.readValues(loc, visitor);
    }

    @Override
    public void handleString(String value) {
        throw new NotImplementedException("Cannot compute percentiles on non numeric values");
    }

    @Override
    public void handleDouble(double value) {
        if (this.doubleValues == null) {
            this.doubleValues = new TDoubleArrayList();
            this.stringValues = null;
        }
        ((TDoubleArrayList)this.doubleValues).add(value);
    }

    @Override
    public void endRead(int location) {
        if (this.doubleValues != null) {
            this.data[location] = this.computePercentile((TDoubleArrayList)this.doubleValues);
        }
    }

    private double computePercentile(TDoubleArrayList values) {
        Percentile p = new Percentile().withEstimationType(Percentile.EstimationType.R_7);
        double percentile = Aggregation.Function.MEDIAN.equals((Object)this.aggregation.function) ? 50.0 : this.aggregation.percentile;
        return p.evaluate(values.toArray(), percentile);
    }
}

