/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.facets;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.facets.AxisFilter;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.text.StringMatchingMode;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StringAxisFilter
implements AxisFilter {
    private final RowFilter filter;
    private final Set<String> values;
    private final boolean exclude;
    private final StringMatchingMode mode;
    private final StringNormalizationMode normalizationMode;
    private final List<Pattern> compiledPatterns = new ArrayList<Pattern>();
    private DecimalFormat df;

    public StringAxisFilter(RowFilter filter) {
        this.filter = filter;
        ChartFilter.CustomOptions customOptions = Objects.requireNonNullElseGet(filter.customOptions, ChartFilter.CustomOptions::new);
        this.mode = customOptions.matchingMode;
        this.normalizationMode = customOptions.normalizationMode;
        List filterValues = Optional.ofNullable(filter.selectedValues != null ? filter.selectedValues : filter.excludedValues).orElseGet(Collections::emptyList);
        boolean bl = this.exclude = !filter.excludeOtherValues;
        if (Objects.requireNonNullElse(customOptions.decimalPlaces, 0) > 0) {
            this.df = new DecimalFormat("#." + String.valueOf('#').repeat(customOptions.decimalPlaces));
        }
        this.values = filterValues.stream().map(val -> {
            if ("___dku_no_value___".equals(val)) {
                return null;
            }
            return this.normalizationMode.apply((String)val);
        }).collect(Collectors.toSet());
        if (this.mode == StringMatchingMode.PATTERN) {
            for (String value : this.values) {
                if (value == null) continue;
                this.compiledPatterns.add(Pattern.compile(value));
            }
        }
    }

    @Override
    public boolean filter(Row row) {
        throw new Error("Bad row");
    }

    @Override
    public void filter(LinoReader reader, int blockIdx, boolean[] ret) throws IOException {
        if (this.values.isEmpty()) {
            return;
        }
        ColumnBlock block = reader.readColumnBlock(this.filter.column, blockIdx);
        int i = 0;
        while (i < block.nbRecords()) {
            boolean matches;
            block10: {
                block9: {
                    double aDouble;
                    String valueForIndex = block.getMemoryType() == ColumnBlock.MemoryType.DOUBLE && this.df != null ? (!Double.isNaN(aDouble = block.doubles[i]) ? this.df.format(aDouble) : null) : block.getAsStringSlow(i);
                    valueForIndex = valueForIndex != null ? this.normalizationMode.apply(valueForIndex) : null;
                    matches = false;
                    if (valueForIndex == null) break block9;
                    block0 : switch (this.mode) {
                        case FULL_STRING: {
                            matches = this.values.contains(valueForIndex);
                            break;
                        }
                        case SUBSTRING: {
                            for (String s : this.values) {
                                matches = s != null && valueForIndex.contains(s);
                                if (!matches) continue;
                                break block0;
                            }
                            break block10;
                        }
                        case PATTERN: {
                            Pattern p;
                            Iterator<Object> iterator = this.compiledPatterns.iterator();
                            while (iterator.hasNext() && !(matches = (p = (Pattern)iterator.next()) != null && p.matcher(valueForIndex).find())) {
                            }
                            break;
                        }
                    }
                    break block10;
                }
                matches = this.values.contains(null);
            }
            int n = i++;
            ret[n] = ret[n] & this.getFilteringStatus(matches);
        }
    }

    private boolean getFilteringStatus(boolean matches) {
        return !this.exclude && matches;
    }
}

