/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.maps;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.LinoAxisHandler;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.maps.PTMapAggrGridRequest;
import com.dataiku.dip.pivot.backend.model.maps.PTMapAggrGridResponse;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TLongIntHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;

public class LinoPointGridAxisHandler
implements LinoAxisHandler {
    private TIntArrayList list = new TIntArrayList();
    private TLongIntHashMap map = new TLongIntHashMap();
    private String lonCol;
    private String latCol;
    PTMapAggrGridRequest req;
    GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
    int gIndex = -1;
    private double outMinLon = -180.0;
    private double outMinLat = -90.0;
    private double outMaxLon = 180.0;
    private double outMaxLat = 90.0;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.charts.geo");

    private long getSquareId(double lon, double lat) {
        long lonIdx = (long)Math.floor((lon - this.req.minLon) / this.req.lonRadiusDeg);
        long latIdx = (long)Math.floor((lat - this.req.minLat) / this.req.latRadiusDeg);
        long lonStride = (long)Math.ceil((this.req.maxLon - this.req.minLon) / this.req.lonRadiusDeg);
        return latIdx * lonStride + lonIdx;
    }

    public LinoPointGridAxisHandler(String lonCol, String latCol, PTMapAggrGridRequest req) throws Exception {
        this.lonCol = lonCol;
        this.latCol = latCol;
        this.req = req;
    }

    @Override
    public void observe(LinoReader reader, int blockIdx, boolean[] filters) throws IOException {
        ColumnBlock lonBlock = reader.readColumnBlock(this.lonCol, blockIdx);
        ColumnBlock latBlock = reader.readColumnBlock(this.latCol, blockIdx);
        for (int i = 0; i < lonBlock.doubles.length; ++i) {
            if (filters != null && !filters[i]) {
                this.list.add(-1);
                continue;
            }
            double lon = lonBlock.doubles[i];
            double lat = latBlock.doubles[i];
            if (lon < this.req.minLon || lon > this.req.maxLon || lat < this.req.minLat || lat > this.req.maxLat) {
                this.list.add(-1);
                continue;
            }
            if (Double.isNaN(lon) || Double.isNaN(lat)) {
                this.list.add(-1);
                continue;
            }
            this.outMinLon = Math.max(this.outMinLon, lon);
            this.outMinLat = Math.max(this.outMinLat, lat);
            this.outMaxLon = Math.min(this.outMaxLon, lon);
            this.outMaxLat = Math.min(this.outMaxLat, lat);
            long squareId = this.getSquareId(lon, lat);
            if (this.map.containsKey(squareId)) {
                this.list.add(this.map.get(squareId));
                continue;
            }
            int newBin = this.map.size();
            this.list.add(newBin);
            this.map.put(squareId, newBin);
        }
    }

    @Override
    public int getNbBins() {
        logger.info((Object)("Used " + this.map.size() + " bins"));
        return this.map.size();
    }

    @Override
    public void getBins(LinoReader reader, int blockIdx, int[] ret, boolean[] filters) throws IOException {
        ColumnBlock lonBlock = reader.readColumnBlock(this.lonCol, blockIdx);
        for (int i = 0; i < lonBlock.nbRecords(); ++i) {
            if (filters != null && !filters[i]) {
                ret[i] = 0;
                ++this.gIndex;
                continue;
            }
            ++this.gIndex;
            ret[i] = this.list.get(this.gIndex);
        }
    }

    public List<GeoGridAxisElt> getGeoAxisElts() throws JSONException {
        long lonStride = (long)Math.ceil((this.req.maxLon - this.req.minLon) / this.req.lonRadiusDeg);
        ArrayList<GeoGridAxisElt> ret = new ArrayList<GeoGridAxisElt>();
        for (long key : this.map.keys()) {
            int bin = this.map.get(key);
            long lonIdx = key % lonStride;
            long latIdx = key / lonStride;
            GeoGridAxisElt g = new GeoGridAxisElt();
            g.binIndex = bin;
            g.lonIdx = lonIdx;
            g.latIdx = latIdx;
            g.minLon = (double)lonIdx * this.req.lonRadiusDeg + this.req.minLon;
            g.minLat = (double)latIdx * this.req.latRadiusDeg + this.req.minLat;
            ret.add(g);
        }
        return ret;
    }

    public void fillBounds(PTMapAggrGridResponse resp) {
        resp.minLon = this.outMinLon;
        resp.maxLon = this.outMaxLon;
        resp.minLat = this.outMinLat;
        resp.maxLat = this.outMaxLat;
    }

    @Override
    public List<AxisElt> getAxisElts() {
        throw new NotImplementedException();
    }

    public static class GeoGridAxisElt {
        public int binIndex;
        public long lonIdx;
        public long latIdx;
        public double minLat;
        public double minLon;
    }
}

