/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.queries;

import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.queries.BinningToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.queries.FilterToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.InputTable;
import com.dataiku.dip.pivot.backend.sql.utils.PartitionUtils;
import com.dataiku.dip.pivot.backend.sql.utils.QueryUtils;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class FacetToSQL {
    private final InputTable input;
    private final List<RowFilter> filters;
    private final RowFilter facet;
    private final SQLDialect dialect;
    private final ColumnMapper colMapping;

    public FacetToSQL(InputTable input, List<RowFilter> filters, RowFilter facet, ColumnMapper colMapping) {
        this.input = input;
        this.filters = filters;
        this.facet = facet;
        this.dialect = input.dialect;
        this.colMapping = colMapping;
    }

    public String buildQuery() {
        return this.createQuery(this.filters).toSQL(this.dialect);
    }

    public String buildNonRelevantValuesQuery() {
        SelectQueryBuilder query = this.createQuery(Collections.emptyList());
        FilterToSQL filterToSQL = new FilterToSQL(this.dialect, this.colMapping);
        for (RowFilter rf : this.filters) {
            ExpressionBuilder expr = filterToSQL.filterExpr(rf);
            if (expr == null) continue;
            query.where(expr.not());
        }
        if (!query.hasFilters()) {
            return null;
        }
        return query.toSQL(this.dialect);
    }

    public SelectQueryBuilder createQuery(List<RowFilter> filters) {
        SelectQueryBuilder query;
        block7: {
            block6: {
                query = new SelectQueryBuilder();
                FilterToSQL filterToSQL = new FilterToSQL(this.dialect, this.colMapping);
                query.from(this.input.table, "main");
                for (RowFilter rf : filters) {
                    filterToSQL.filterQuery(query, rf);
                }
                if (this.facet.filterType == ChartFilter.FilterType.EXPLICIT) break block6;
                switch (this.facet.columnType) {
                    case ALPHANUM: {
                        this.handleAlphanumColumn(this.facet.column, ColumnMapper.ExprType.NON_NULL_STRING, query, this.facet.facetSorting);
                        break block7;
                    }
                    case DATE: {
                        this.handleDateColumn(this.facet.column, this.facet.dateFilterType, this.facet.dateFilterPart, query, this.facet.facetSorting);
                        break block7;
                    }
                    case NUMERICAL: {
                        this.handleNumericalColumn(this.facet.column, this.facet.filterType, query, this.facet.facetSorting);
                        break block7;
                    }
                    default: {
                        throw new UnsupportedOperation("Unsupported column type: " + String.valueOf((Object)this.facet.columnType));
                    }
                }
            }
            this.handleExplicitFilter(this.facet, query);
        }
        PartitionUtils.appendPartitionFilteringClause(this.input, query);
        return query;
    }

    private void handleExplicitFilter(RowFilter explicitFilter, SelectQueryBuilder query) {
        block5: for (ChartFilter.ExplicitCondition explicitCondition : explicitFilter.explicitConditions) {
            switch (explicitCondition.columnType) {
                case ALPHANUM: {
                    this.handleAlphanumColumn(explicitCondition.column, ColumnMapper.ExprType.NON_NULL_STRING, query, null);
                    continue block5;
                }
                case DATE: {
                    this.handleDateColumn(explicitCondition.column, explicitCondition.dateFilterType, explicitCondition.dateFilterPart, query, null);
                    continue block5;
                }
                case NUMERICAL: {
                    this.handleNumericalColumn(explicitCondition.column, ChartFilter.FilterType.NUMERICAL_FACET, query, null);
                    continue block5;
                }
            }
            throw new UnsupportedOperation("Unsupported column type: " + String.valueOf((Object)this.facet.columnType));
        }
    }

    private void handleAlphanumColumn(String column, ColumnMapper.ExprType exprType, SelectQueryBuilder query, ChartFilter.FilterSortingOptions facetSorting) {
        ColumnMapper.TypedExpr columnAsString = this.colMapping.getAs(column, exprType);
        ExpressionBuilder selectExpression = ExpressionUtils.ef.expr(columnAsString.expr);
        this.addSelectAndOrder(query, selectExpression, exprType, Objects.requireNonNullElse(facetSorting, ChartFilter.FilterSortingOptions.COUNT_DESC));
    }

    private void handleNumericalColumn(String column, ChartFilter.FilterType filterType, SelectQueryBuilder query, ChartFilter.FilterSortingOptions facetSorting) {
        if (ChartFilter.FilterType.ALPHANUM_FACET.equals((Object)filterType)) {
            this.handleAlphanumColumn(column, ColumnMapper.ExprType.NUMBER, query, facetSorting);
        } else {
            ColumnMapper.TypedExpr columnAsNumber = this.colMapping.getAs(column, ColumnMapper.ExprType.NUMBER);
            query.select(ExpressionUtils.ef.expr(columnAsNumber.expr).min());
            query.select(ExpressionUtils.ef.expr(columnAsNumber.expr).max());
        }
    }

    private void handleDateColumn(String column, ChartFilter.DateFilterType dateFilterType, ChartFilter.DateFilterPart dateFilterPart, SelectQueryBuilder query, ChartFilter.FilterSortingOptions facetSorting) {
        ColumnMapper.TypedExpr columnAsDate = this.colMapping.getAs(column, ColumnMapper.ExprType.DATE);
        if (dateFilterType == ChartFilter.DateFilterType.RANGE) {
            query.select(ExpressionUtils.ef.expr(this.dialect.datePartExpression(columnAsDate.expr, DatePart.SECOND_FROM_EPOCH)).min());
            query.select(ExpressionUtils.ef.expr(this.dialect.datePartExpression(columnAsDate.expr, DatePart.SECOND_FROM_EPOCH)).max());
        } else {
            BinningToSQL binningToSQL = new BinningToSQL(this.dialect, this.colMapping);
            ExpressionBuilder expr = ExpressionUtils.ef.expr(this.colMapping.getAs((ColumnMapper.TypedExpr)binningToSQL.binningExpression((ColumnMapper.TypedExpr)columnAsDate, (ChartFilter.DateFilterType)dateFilterType, (ChartFilter.DateFilterPart)dateFilterPart), (ColumnMapper.ExprType)ColumnMapper.ExprType.NON_NULL_NUMBER).expr);
            this.addSelectAndOrder(query, expr, ColumnMapper.ExprType.NON_NULL_NUMBER, Objects.requireNonNullElse(facetSorting, ChartFilter.FilterSortingOptions.NATURAL_ORDER_ASC));
        }
    }

    private void addSelectAndOrder(SelectQueryBuilder query, ExpressionBuilder expr, ColumnMapper.ExprType exprType, ChartFilter.FilterSortingOptions facetSorting) {
        QueryAst.OrderType orderType;
        String selectAlias = QueryUtils.safeRandomIdentifier("select_");
        SelectQueryBuilder.SelectRefBuilder select = this.dialect.hasAccessToAliasInOrderByCaseStatement() ? query.select(expr, selectAlias) : query.select(expr);
        SelectQueryBuilder.SelectRefBuilder countRef = query.select(ExpressionUtils.ef.count("*"));
        QueryAst.OrderType orderType2 = orderType = facetSorting.isAscending() ? QueryAst.OrderType.ASC : QueryAst.OrderType.DESC;
        if (facetSorting.getType() == ChartFilter.FilterSortingType.NATURAL_ORDER) {
            if (exprType.type == ColumnMapper.BaseType.STRING) {
                if (this.dialect instanceof SparkSQLDialect) {
                    query.order(ExpressionUtils.ef.caseWhen(expr.eq("___dku_no_value___").or(expr.isBlank()), ExpressionUtils.ef.cst(orderType == QueryAst.OrderType.DESC ? 0 : 1), ExpressionUtils.ef.cst(orderType == QueryAst.OrderType.DESC ? 1 : 0)), orderType);
                } else if (this.dialect.hasAccessToAliasInOrderByCaseStatement()) {
                    query.order(ExpressionUtils.ef.caseWhen(ExpressionUtils.ef.expr(selectAlias).eq("___dku_no_value___"), ExpressionUtils.ef.cst(orderType == QueryAst.OrderType.DESC ? 0 : 1), ExpressionUtils.ef.cst(orderType == QueryAst.OrderType.DESC ? 1 : 0)), orderType);
                } else {
                    query.order(ExpressionUtils.ef.caseWhen(expr.eq("___dku_no_value___"), ExpressionUtils.ef.cst(orderType == QueryAst.OrderType.DESC ? 0 : 1), ExpressionUtils.ef.cst(orderType == QueryAst.OrderType.DESC ? 1 : 0)), orderType);
                }
            }
            query.order(select, orderType, QueryAst.OrderType.DESC);
        }
        if (facetSorting.getType() == ChartFilter.FilterSortingType.COUNT) {
            query.order(countRef, orderType);
            query.order(select, orderType);
        }
        if (this.dialect.supportGroupByIndex()) {
            query.group(select);
        } else {
            query.group(expr);
        }
    }
}

