/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.utils;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.utils.DoubleUtils;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.DateRelativeFilterHelper;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInterval;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class FilterUtils {
    public static boolean isIncludedIn(List<RowFilter> small, List<RowFilter> big) {
        ArrayList<RowFilter> intersection = new ArrayList<RowFilter>();
        intersection.addAll(small);
        intersection.addAll(big);
        return FilterUtils.isEquivalent(FilterUtils.intersectAndSort(intersection), FilterUtils.intersectAndSort(big));
    }

    public static boolean isSameFacet(RowFilter rf1, RowFilter rf2) {
        if (!StringUtils.equals((String)rf1.column, (String)rf2.column)) {
            return false;
        }
        if (rf1.columnType != rf2.columnType) {
            return false;
        }
        if (rf2.columnType == AxisDef.Type.DATE) {
            if (rf1.dateFilterType != rf2.dateFilterType) {
                return false;
            }
            if (rf1.dateFilterType == ChartFilter.DateFilterType.PART && rf1.dateFilterPart != rf2.dateFilterPart) {
                return false;
            }
        }
        if (rf2.columnType == AxisDef.Type.NUMERICAL && rf1.filterType != rf2.filterType) {
            return false;
        }
        if (FilterUtils.isASelectedValuesFilter(rf1) != FilterUtils.isASelectedValuesFilter(rf2)) {
            return false;
        }
        if (rf1.allValuesInSample != rf2.allValuesInSample) {
            return false;
        }
        if (!Objects.equals(rf1.includeEmptyValues, rf2.includeEmptyValues)) {
            return false;
        }
        return FilterUtils.getDefaultSorting(rf1) == FilterUtils.getDefaultSorting(rf2);
    }

    public static ChartFilter.FilterSortingOptions getDefaultSorting(RowFilter filter) {
        if (filter.filterType == ChartFilter.FilterType.DATE_FACET) {
            return Objects.requireNonNullElse(filter.facetSorting, ChartFilter.FilterSortingOptions.NATURAL_ORDER_ASC);
        }
        return Objects.requireNonNullElse(filter.facetSorting, ChartFilter.FilterSortingOptions.COUNT_DESC);
    }

    public static boolean isSameFilter(RowFilter rf1, RowFilter rf2) {
        if (!FilterUtils.isSameFacet(rf1, rf2)) {
            return false;
        }
        if (FilterUtils.isRangeBased(rf1)) {
            return DoubleUtils.equals(rf1.maxValue, rf2.maxValue) && DoubleUtils.equals(rf1.minValue, rf2.minValue);
        }
        if (rf1.excludeOtherValues) {
            if (rf1.selectedValues == null || rf2.selectedValues == null) {
                return rf1.selectedValues == null && rf2.selectedValues == null;
            }
            if (!new HashSet<String>(rf1.selectedValues).equals(new HashSet<String>(rf2.selectedValues))) {
                return false;
            }
            return Objects.equals(rf1.customOptions, rf2.customOptions);
        }
        if (rf1.filterType == ChartFilter.FilterType.EXPLICIT) {
            return rf1.column.equals(rf2.column);
        }
        if (rf1.excludedValues == null || rf2.excludedValues == null) {
            return rf1.excludedValues == null && rf2.excludedValues == null;
        }
        if (!new HashSet<String>(rf1.excludedValues).equals(new HashSet<String>(rf2.excludedValues))) {
            return false;
        }
        return Objects.equals(rf1.customOptions, rf2.customOptions);
    }

    public static boolean isEquivalent(List<RowFilter> rfs1, List<RowFilter> rfs2) {
        List<RowFilter> sortedRfs1 = FilterUtils.intersectAndSort(rfs1);
        List<RowFilter> sortedRfs2 = FilterUtils.intersectAndSort(rfs2);
        if (sortedRfs1.size() != sortedRfs2.size()) {
            return false;
        }
        for (int i = 0; i < sortedRfs1.size(); ++i) {
            RowFilter rf2;
            RowFilter rf1 = sortedRfs1.get(i);
            if (FilterUtils.isSameFilter(rf1, rf2 = sortedRfs2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isRangeBased(RowFilter rf) {
        if (rf.filterType == ChartFilter.FilterType.EXPLICIT) {
            return false;
        }
        return rf.columnType == AxisDef.Type.NUMERICAL && rf.filterType != ChartFilter.FilterType.ALPHANUM_FACET && rf.filterType != ChartFilter.FilterType.ALPHANUM || rf.columnType == AxisDef.Type.DATE && rf.dateFilterType == ChartFilter.DateFilterType.RANGE;
    }

    public static boolean isTakingAllValues(RowFilter rf) {
        if (FilterUtils.isRangeBased(rf)) {
            return rf.minValue == null && rf.maxValue == null && rf.getIncludeEmptyValuesOrDefault();
        }
        if (rf.filterType == ChartFilter.FilterType.EXPLICIT) {
            return rf.explicitConditions == null || rf.explicitConditions.isEmpty();
        }
        if (!FilterUtils.isASelectedValuesFilter(rf) && (rf.excludedValues == null || rf.excludedValues.isEmpty())) {
            return true;
        }
        if (rf.filterType == ChartFilter.FilterType.ALPHANUM) {
            return !FilterUtils.isASelectedValuesFilter(rf) && rf.excludedValues != null && rf.excludedValues.isEmpty() || FilterUtils.isASelectedValuesFilter(rf) && rf.selectedValues != null && rf.selectedValues.isEmpty();
        }
        return false;
    }

    public static void expandRelativeDateFilters(PivotTableRequest request) {
        if (request.filters != null) {
            FilterUtils.expandRelativeDateFilters(request.filters);
        }
        if (request.sideRequests != null) {
            request.sideRequests.values().forEach(srl -> {
                if (srl != null) {
                    srl.forEach(sr -> {
                        if (sr.filters != null) {
                            FilterUtils.expandRelativeDateFilters(sr.filters);
                        }
                    });
                }
            });
        }
    }

    public static List<RowFilter> intersectAndSort(List<RowFilter> rfs) {
        TreeMap<CallSite, RowFilter> map = new TreeMap<CallSite, RowFilter>();
        for (RowFilter rf : rfs) {
            String key;
            if (!rf.active || FilterUtils.isTakingAllValues(rf)) continue;
            if (rf.filterType == ChartFilter.FilterType.EXPLICIT) {
                key = rf.filterType.name() + "##";
                key = key + rf.explicitConditions.stream().map(FilterUtils::buildExplicitConditionKey).collect(Collectors.joining("##"));
            } else {
                key = rf.columnType == AxisDef.Type.DATE ? rf.columnType.name() + "#" + rf.dateFilterType.name() + (String)(rf.dateFilterType == ChartFilter.DateFilterType.PART ? "#" + rf.dateFilterPart.name() : "") + "#" + rf.column : rf.columnType.name() + "##" + rf.column;
                if (!FilterUtils.isRangeBased(rf)) {
                    if (rf.filterType == ChartFilter.FilterType.ALPHANUM) {
                        ChartFilter.CustomOptions customOptions = Objects.requireNonNullElseGet(rf.customOptions, ChartFilter.CustomOptions::new);
                        key = key + String.join((CharSequence)"##", Optional.ofNullable(rf.selectedValues != null ? rf.selectedValues : rf.excludedValues).orElse(Collections.emptyList()));
                        key = key + "##" + customOptions.matchingMode.toString();
                        key = key + "##" + customOptions.normalizationMode.toString();
                    } else {
                        key = key + "##isSelectedMode=" + FilterUtils.isASelectedValuesFilter(rf);
                    }
                }
            }
            RowFilter existingFilter = (RowFilter)map.get(key);
            if (existingFilter == null) {
                existingFilter = (RowFilter)JSON.deepCopy((Object)rf);
                map.put((CallSite)((Object)key), existingFilter);
            }
            if (rf.filterType == ChartFilter.FilterType.EXPLICIT || rf.filterType == ChartFilter.FilterType.ALPHANUM) continue;
            if (!FilterUtils.isRangeBased(rf)) {
                TreeSet<String> values = new TreeSet<String>();
                if (FilterUtils.isASelectedValuesFilter(rf)) {
                    values.addAll(existingFilter.selectedValues);
                    values.retainAll(rf.selectedValues);
                    existingFilter.selectedValues = new ArrayList<String>(values);
                    continue;
                }
                values.addAll(rf.excludedValues);
                values.addAll(existingFilter.excludedValues);
                existingFilter.excludedValues = new ArrayList<String>(values);
                continue;
            }
            if (rf.minValue != null) {
                existingFilter.minValue = existingFilter.minValue != null ? Double.valueOf(Math.max(rf.minValue, existingFilter.minValue)) : rf.minValue;
            }
            if (rf.maxValue == null) continue;
            if (existingFilter.maxValue != null) {
                existingFilter.maxValue = Math.min(rf.maxValue, existingFilter.maxValue);
                continue;
            }
            existingFilter.maxValue = rf.maxValue;
        }
        return new ArrayList<RowFilter>(map.values());
    }

    public static boolean isASelectedValuesFilter(RowFilter rowFilter) {
        return rowFilter.excludeOtherValues && rowFilter.selectedValues != null;
    }

    public static long getAlphanumFacetsSafetyThreshold() {
        return DKUApp.getParams().getIntParam("dku.charts.alphanumFacetsSafetyThreshold", Integer.valueOf(10000));
    }

    private static String buildExplicitConditionKey(ChartFilter.ExplicitCondition explicitCondition) {
        StringBuilder explicitConditionStringBuilder = new StringBuilder();
        explicitConditionStringBuilder.append(explicitCondition.column).append("#").append(explicitCondition.columnType.name());
        if (explicitCondition.dateFilterType != null) {
            explicitConditionStringBuilder.append("#").append(explicitCondition.dateFilterType.name());
        }
        if (explicitCondition.dateFilterPart != null) {
            explicitConditionStringBuilder.append("#").append(explicitCondition.dateFilterPart.name());
        }
        if (explicitCondition.singleValue != null) {
            explicitConditionStringBuilder.append("#").append(explicitCondition.singleValue);
        }
        if (explicitCondition.minValue != null) {
            explicitConditionStringBuilder.append("#").append(explicitCondition.minValue);
        }
        if (explicitCondition.maxValue != null) {
            explicitConditionStringBuilder.append("#").append(explicitCondition.maxValue);
        }
        return explicitConditionStringBuilder.toString();
    }

    private static void expandRelativeDateFilters(List<RowFilter> filters) {
        DateTime now = new DateTime().withZone(DateTimeZone.UTC);
        for (RowFilter filter : filters) {
            if (filter.filterType != ChartFilter.FilterType.DATE_FACET || filter.dateFilterType != ChartFilter.DateFilterType.RELATIVE) continue;
            filter.dateFilterType = ChartFilter.DateFilterType.RANGE;
            if (filter.dateFilterOption == null || !filter.dateFilterOption.isEffective()) continue;
            ReadableInterval bounds = DateRelativeFilterHelper.computeInterval(filter.dateFilterPart, filter.dateFilterOption, (ReadableInstant)now);
            filter.minValue = bounds.getStartMillis();
            filter.maxValue = bounds.getEndMillis();
        }
    }

    public static List<String> getValues(RowFilter filter) {
        return filter.excludeOtherValues ? filter.selectedValues : filter.excludedValues;
    }

    public static boolean hasOnlyAlphanumAndEmptyFilters(List<RowFilter> filters) {
        boolean hasOnlyEmptyFilters = true;
        for (RowFilter filter : filters) {
            hasOnlyEmptyFilters &= FilterUtils.canFilterAsAlphanum(filter) && FilterUtils.getValues(filter).isEmpty();
        }
        return hasOnlyEmptyFilters;
    }

    public static boolean canFilterAsAlphanum(RowFilter rf) {
        if (rf.excludedValues != null || rf.selectedValues != null) {
            if (rf.filterType == ChartFilter.FilterType.ALPHANUM) {
                return rf.excludedValues != null && !rf.excludedValues.isEmpty() || rf.selectedValues != null && !rf.selectedValues.isEmpty();
            }
            return rf.columnType == AxisDef.Type.ALPHANUM || rf.columnType == AxisDef.Type.DATE && rf.dateFilterType == ChartFilter.DateFilterType.PART;
        }
        return false;
    }
}

