/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel;

import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.TensorType;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.frontend.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.BaseDataSheet2DBuilder;
import com.dataiku.dip.pivot.frontend.excel.CellStyler;
import com.dataiku.dip.pivot.frontend.excel.xssf.SheetUtils;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.pivot.frontend.model.FontFormatting;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.FillPatternType;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Font;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Workbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFCellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFColor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFFont;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFSheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class KpiDataSheetBuilder
extends BaseDataSheet2DBuilder {
    public static void buildMatrixSheet(XSSFWorkbook workbook, ChartDef chartDef, PivotTableTensorResponse response, @Nullable List<FontFormatting> colorMaps) {
        XSSFSheet sheet = workbook.createSheet("Data");
        CellStyler styler = new CellStyler((Workbook)workbook);
        SheetReference sheetRef = new SheetReference(sheet, styler, 0, 0);
        ArrayList<Map<String, XSSFColor>> backgroundColorMapping = null;
        ArrayList<Map<String, XSSFColor>> fontColorMapping = null;
        if (colorMaps != null && !colorMaps.isEmpty()) {
            backgroundColorMapping = new ArrayList<Map<String, XSSFColor>>();
            fontColorMapping = new ArrayList<Map<String, XSSFColor>>();
            for (int measureIndex = 0; measureIndex < colorMaps.size(); ++measureIndex) {
                FontFormatting.getColorMapping(workbook, measureIndex, colorMaps.get(measureIndex).getBackgroundColorMap(), backgroundColorMapping);
                FontFormatting.getColorMapping(workbook, measureIndex, colorMaps.get(measureIndex).getFontColorMap(), fontColorMapping);
            }
        }
        SheetUtils.writeCell(sheet, sheetRef.row++, sheetRef.column, chartDef.name).setCellStyle(styler.getTitleStyle());
        for (int i = 0; i < response.aggregations.size(); ++i) {
            XSSFColor color;
            DataTensor tensor = (DataTensor)response.aggregations.get(i);
            XSSFCellStyle cellStyle = (XSSFCellStyle)styler.getSubtitleStyle();
            if (fontColorMapping != null && !((Map)fontColorMapping.get(i)).isEmpty()) {
                color = FontFormatting.getColor(i, tensor, fontColorMapping);
                cellStyle = cellStyle.copy();
                XSSFFont font = sheetRef.styler.getValueFont(color);
                cellStyle.setFont((Font)font);
            }
            if (backgroundColorMapping != null && !((Map)backgroundColorMapping.get(i)).isEmpty() && (color = FontFormatting.getColor(i, tensor, backgroundColorMapping)) != null) {
                cellStyle.setFillForegroundColor(color);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            SheetUtils.writeCell(sheet, sheetRef.row, sheetRef.column, ChartUtils.getNiceMeasureName(chartDef.genericMeasures.get(i))).setCellStyle(styler.getSubtitleStyle());
            if (tensor.type == TensorType.NUMERICAL) {
                SheetUtils.writeCell(sheet, sheetRef.row++, sheetRef.column + 1, tensor.getAsDouble(0)).setCellStyle((CellStyle)cellStyle);
                continue;
            }
            if (tensor.type == TensorType.ALPHANUM) {
                SheetUtils.writeCell(sheet, sheetRef.row++, sheetRef.column + 1, (String)tensor.get(0)).setCellStyle((CellStyle)cellStyle);
                continue;
            }
            if (tensor.type == TensorType.DATE) {
                sheetRef.styler.setStyleFormat(cellStyle, tensor.type);
                SheetUtils.writeCell(sheet, sheetRef.row++, sheetRef.column + 1, (DateTime)tensor.get(0, true)).setCellStyle((CellStyle)cellStyle);
                continue;
            }
            throw new RuntimeException("Only numerical and alphanumeric values can be written on a sheet.");
        }
        KpiDataSheetBuilder.appendFilteringDetails(chartDef, sheet);
        SheetUtils.autoFitColumns(sheet);
    }

    private static class SheetReference {
        public XSSFSheet sheet;
        public CellStyler styler;
        public int row;
        public int column;

        public SheetReference(XSSFSheet sheet, CellStyler styler, int row, int column) {
            this.sheet = sheet;
            this.styler = styler;
            this.row = row;
            this.column = column;
        }
    }
}

