/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.queries;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.util.List;

public class QueryBunch {
    public List<String> preQueries = Lists.newArrayList();
    public List<String> optionalPreQueries = Lists.newArrayList();
    public List<String> postQueries = Lists.newArrayList();
    public String query;
    public int selectedItemsCount = -1;
    public String namedLock = null;
    public String inputQuery = null;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.sql");

    public QueryBunch() {
    }

    public QueryBunch(String query) {
        this.query = query;
    }

    public QueryBunch clone() {
        QueryBunch ret = new QueryBunch();
        ret.preQueries = Lists.newArrayList(this.preQueries);
        ret.optionalPreQueries = Lists.newArrayList(this.optionalPreQueries);
        ret.postQueries = Lists.newArrayList(this.postQueries);
        ret.query = this.query;
        ret.selectedItemsCount = this.selectedItemsCount;
        return ret;
    }

    public static QueryBunch fromScript(SQLConnectionProvider.SQLConnectionData connData, String script) throws Exception {
        return QueryBunch.fromScript(connData.getDialect(), script);
    }

    public static QueryBunch fromScript(SQLDialect dialect, String script) throws Exception {
        Splitter splitter = new Splitter(dialect.getSemicolonExclusionPortionFinders());
        String[] statementSqls = splitter.split(script);
        int selectStatementIndex = SQLUtils.findLastSelectStatement(statementSqls, splitter);
        logger.info((Object)("Found " + statementSqls.length + " parts and the index of the select is " + selectStatementIndex));
        QueryBunch ret = new QueryBunch();
        if (selectStatementIndex < 0) {
            ret.query = script;
        } else {
            int i;
            for (i = 0; i < selectStatementIndex; ++i) {
                ret.preQueries.add(statementSqls[i]);
            }
            for (i = selectStatementIndex + 1; i < statementSqls.length; ++i) {
                ret.postQueries.add(statementSqls[i]);
            }
            ret.query = statementSqls[selectStatementIndex];
        }
        return ret;
    }
}

