/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.univariate;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.filtering.AnumFilter;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.worksheets.cards.common.SummaryStats;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.UnivariateSummaryStatsBuilder;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.recipes.eda.FilterFormatter;
import com.dataiku.dip.recipes.eda.UnivariateRecipePayloadParams;
import com.dataiku.dip.recipes.eda.univariate.UnivariateAnalysis;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class UnivariateAnalysisSummaryStats
extends UnivariateAnalysis {
    public static final String TYPE = "SUMMARY_STATS";
    public UnivariateSummaryStatsBuilder.StatsToCompute compute = new UnivariateSummaryStatsBuilder.StatsToCompute();

    public UnivariateAnalysisSummaryStats(Variable column) {
        this.column = column;
    }

    private UnivariateAnalysisSummaryStats() {
    }

    @Override
    public Computation getComputationPlan(UnivariateRecipePayloadParams payloadParams) {
        SummaryStats summaryStats = new UnivariateSummaryStatsBuilder(this.column, payloadParams.confidenceLevel, payloadParams.withConfidenceIntervals, this.compute).buildSummaryStats();
        return summaryStats.getComputationPlan();
    }

    @Override
    public List<Row> extractRows(ComputationResult result, UnivariateRecipePayloadParams payloadParams, ColumnFactory cf, RowFactory rf) {
        List<SummaryStats.ComputedStat> computedStats;
        SummaryStats summaryStats = new UnivariateSummaryStatsBuilder(this.column, payloadParams.confidenceLevel, payloadParams.withConfidenceIntervals, this.compute).buildSummaryStats();
        ArrayList<Row> rows = new ArrayList<Row>();
        List<String> warnings = result.collectWarnings();
        Collection<String> errors = result.collectErrors();
        if (result.isAvailable()) {
            MultiComputation.MultiComputationResult mcr = (MultiComputation.MultiComputationResult)result;
            computedStats = summaryStats.getComputedStats(mcr);
        } else {
            computedStats = summaryStats.getNotComputedStats();
        }
        for (SummaryStats.ComputedStat stat : computedStats) {
            List<Row> rowsForStat = this.extractRows(stat, warnings, errors, payloadParams, cf, rf);
            rows.addAll(rowsForStat);
        }
        return rows;
    }

    private List<Row> extractRows(SummaryStats.ComputedStat stat, Collection<String> warnings, Collection<String> errors, UnivariateRecipePayloadParams payloadParams, ColumnFactory cf, RowFactory rf) {
        ArrayList<Row> rows = new ArrayList<Row>();
        Row row = this.rowBase(stat, warnings, errors, cf, rf);
        row.put(cf.column("statistic_type"), stat.statType);
        if (stat.type == SummaryStats.ComputedStatType.INT && stat.intValue != null) {
            row.put(cf.column("value"), stat.intValue.longValue());
        }
        if (stat.type == SummaryStats.ComputedStatType.FLOAT && stat.floatValue != null) {
            row.put(cf.column("value"), stat.floatValue.doubleValue());
        }
        if (stat.type == SummaryStats.ComputedStatType.FILTERS && stat.filterValues != null && stat.filterValues.length > 0) {
            Filter filter = stat.filterValues[0];
            if (!(filter instanceof AnumFilter)) {
                throw new IllegalArgumentException(String.format("Unexpected filter for summary stat mode: %s", ((Object)((Object)filter)).getClass().getSimpleName()));
            }
            AnumFilter anumFilter = (AnumFilter)filter;
            row.put(cf.column("value"), FilterFormatter.formatValue(anumFilter));
        }
        rows.add(row);
        if (payloadParams.withConfidenceIntervals && stat.supportsConfidenceInterval) {
            row = this.rowBase(stat, warnings, errors, cf, rf);
            row.put(cf.column("statistic_type"), String.format("%s_CI_LOWER", stat.statType));
            if (stat.lower != null) {
                row.put(cf.column("value"), stat.lower.doubleValue());
            }
            rows.add(row);
            row = this.rowBase(stat, warnings, errors, cf, rf);
            row.put(cf.column("statistic_type"), String.format("%s_CI_UPPER", stat.statType));
            if (stat.upper != null) {
                row.put(cf.column("value"), stat.upper.doubleValue());
            }
            rows.add(row);
        }
        return rows;
    }

    private Row rowBase(SummaryStats.ComputedStat stat, Collection<String> warnings, Collection<String> errors, ColumnFactory cf, RowFactory rf) {
        Row row = rf.row();
        row.put(cf.column("variable"), this.column.name);
        row.put(cf.column("origin"), TYPE);
        if (stat.type == SummaryStats.ComputedStatType.NOT_COMPUTED) {
            if (!warnings.isEmpty()) {
                row.put(cf.column("warnings"), JSON.json(warnings));
            }
            if (!errors.isEmpty()) {
                row.put(cf.column("errors"), JSON.json(errors));
            }
        } else {
            if (stat.warning != null && !stat.warning.isEmpty()) {
                row.put(cf.column("warnings"), JSON.json(Collections.singletonList(stat.warning)));
            }
            if (stat.failureMessage != null && !stat.failureMessage.isEmpty()) {
                row.put(cf.column("errors"), JSON.json(Collections.singletonList(stat.failureMessage)));
            }
        }
        return row;
    }
}

