/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.fromapp;

import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.fromapp.AppRecipeParams;
import com.dataiku.dip.recipes.fromapp.AppRecipeRunner;
import com.dataiku.dip.spark.SparkOverrideConfig;
import org.apache.commons.lang.StringUtils;

public class AppRecipeMeta
extends RecipeMeta {
    public static final String APP_RECIPE_BASE_ID = "App_";
    private String appId;
    private AppManifest appManifest;

    public AppRecipeMeta(String appId, AppManifest appManifest) {
        this.appId = appId;
        this.appManifest = appManifest;
    }

    @Override
    public String getType() {
        return APP_RECIPE_BASE_ID + this.appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public AppManifest getManifest() {
        return this.appManifest;
    }

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return AppRecipeParams.class;
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        return new AppRecipeRunner(activity);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return RecipeMeta.defaultStatusComputer("DSS", "DSS", "DSS", "DSS", "DSS");
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        RecipeDesc.IORoleDef def;
        RecipeDesc rd = new RecipeDesc();
        for (AppManifest.AppUseAsRecipeSettings.RoleMapping rm2 : this.appManifest.useAsRecipeSettings.inputRoles) {
            if (StringUtils.isBlank((String)rm2.objectId)) continue;
            def = this.roleFromMapping(rm2);
            rd.inputRoles.add(def);
        }
        for (AppManifest.AppUseAsRecipeSettings.RoleMapping rm2 : this.appManifest.useAsRecipeSettings.outputRoles) {
            if (StringUtils.isBlank((String)rm2.objectId)) continue;
            def = this.roleFromMapping(rm2);
            rd.outputRoles.add(def);
        }
        return rd;
    }

    private RecipeDesc.IORoleDef roleFromMapping(AppManifest.AppUseAsRecipeSettings.RoleMapping rm2) {
        RecipeDesc.IORoleDef def = new RecipeDesc.IORoleDef(rm2.objectId, rm2.roleLabel);
        def.acceptsDataset = false;
        def.acceptsManagedFolder = false;
        def.acceptsMLModel = false;
        def.acceptsModelEvaluationStore = false;
        def.acceptsPromptableModel = false;
        if (rm2.type == FlowComputable.FCType.DATASET) {
            def.acceptsDataset = true;
        } else if (rm2.type == FlowComputable.FCType.MANAGED_FOLDER) {
            def.acceptsManagedFolder = true;
        } else if (rm2.type == FlowComputable.FCType.MODEL_EVALUATION_STORE) {
            def.acceptsModelEvaluationStore = true;
        } else if (rm2.type == FlowComputable.FCType.SAVED_MODEL) {
            def.acceptsMLModel = true;
            def.acceptsPromptableModel = true;
        }
        return def;
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags();
    }

    @Override
    public boolean hasJsonPayload() {
        return false;
    }

    @Override
    public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
        throw new Error("unreachable");
    }

    @Override
    public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
        throw new Error("unreachable");
    }

    @Override
    public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
        throw new Error("unreachable");
    }

    public static boolean isAppAsRecipeTemplate(String projectKey, SerializedProject.ProjectAppType projectAppType) {
        return projectAppType == SerializedProject.ProjectAppType.APP_TEMPLATE && RecipeRegistry.hasMeta(AppRecipeMeta.buildRecipeType(projectKey));
    }

    private static String buildRecipeType(String projectKey) {
        return APP_RECIPE_BASE_ID + AppsService.buildApplicationId(projectKey);
    }
}

