/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.common.doc_extraction;

import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.MultimodalPart;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.MultimodalTextPart;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.chunks.RuleChunk;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.chunks.SingleExtractedChunk;
import java.util.ArrayList;
import java.util.List;

public class ExtractedData {
    public List<SingleExtractedChunk> chunks = new ArrayList<SingleExtractedChunk>();
    public String assetsStoragePath;
    public ExtractorEngine extractorEngine;
    public InputRefs.ManagedFolderDocumentRef sourceDocument;

    public ExtractedData(ExtractorEngine extractorEngine, InputRefs.ManagedFolderDocumentRef document) {
        this.extractorEngine = extractorEngine;
        this.sourceDocument = document;
    }

    void createChunks(List<String> embedValues, SingleExtractedChunk chunk, boolean useEmbedValuesAsMultimodal) {
        MultimodalPart multimodalPart = chunk.multimodalPart;
        for (String embedValue : embedValues) {
            if (useEmbedValuesAsMultimodal) {
                multimodalPart = new MultimodalTextPart(embedValue);
            }
            this.chunks.add(new SingleExtractedChunk(embedValue, multimodalPart, chunk.extractedMetadata, chunk.json));
        }
    }

    void createFromRuleChunks(List<RuleChunk> chunks) {
        for (RuleChunk chunk : chunks) {
            this.chunks.add(new SingleExtractedChunk(chunk.getTextValue(), chunk.getMultimodalValue(), chunk.getGeneratedMetadata(this.sourceDocument), chunk.toJson()));
        }
    }

    public static enum ExtractorEngine {
        STRUCTURED("structured"),
        VLM("vlm");

        public String displayName;

        private ExtractorEngine(String displayName) {
            this.displayName = displayName;
        }
    }
}

