/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.embed_documents;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.docextraction.StructuredExtractor;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRecipesParams;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRecipesStatusComputerBase;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRule;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipePayloadParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import java.util.List;

public class EmbedDocumentsRecipeStatusComputer
extends DocExtractionRecipesStatusComputerBase {
    @Override
    public DocExtractionRecipesStatusComputerBase.DocExtractionRecipesStatus buildStatus() {
        return new EmbedDocumentsRecipeStatus();
    }

    public EmbedDocumentsRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            EmbedDocumentsRecipeStatus status = (EmbedDocumentsRecipeStatus)this.fastStatusIgnorePartitions(authCtx);
            this.fillDocExtractionCommonStatus(status, authCtx);
            EmbedDocumentsRecipePayloadParams desc = (EmbedDocumentsRecipePayloadParams)JSON.parse((String)this.payload, EmbedDocumentsRecipePayloadParams.class);
            if (this.recipe.getInputsForRole("metadata_dataset").stream().findFirst().isPresent()) {
                status.metadataDataset = new RecipeStatus.StepStatus();
                if (desc.filePathMetadataColumn == null) {
                    status.metadataDataset.withFatal(RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "Metadata dataset requires the selection of a path column");
                }
            } else {
                status.metadataDataset = null;
            }
            EmbedDocumentsRecipeStatus embedDocumentsRecipeStatus = status;
            return embedDocumentsRecipeStatus;
        }
    }

    @Override
    protected boolean isOutputFolderRequired(DocExtractionRecipesParams params, List<DocExtractionRule> allCustomRules) {
        return params.extractionMode == DocExtractionRecipesParams.ExtractionMode.MANAGED_VISUAL_ONLY || params.extractionMode == DocExtractionRecipesParams.ExtractionMode.MANAGED_TEXT_ONLY && StructuredExtractor.ImageHandlingMode.VLM_ANNOTATE.equals((Object)params.defaultImageHandlingMode) || params.extractionMode == DocExtractionRecipesParams.ExtractionMode.CUSTOM_RULES && params.getAllRules().stream().anyMatch(rule -> rule.actionToPerform == DocExtractionRule.ActionToPerform.VLM && rule.storeInMultimodalColumn.equals((Object)DocExtractionRule.MultimodalContentType.IMAGES) || rule.actionToPerform == DocExtractionRule.ActionToPerform.STRUCTURED && StructuredExtractor.ImageHandlingMode.VLM_ANNOTATE.equals((Object)rule.structuredSettings.imageHandlingMode));
    }

    public static class EmbedDocumentsRecipeStatus
    extends DocExtractionRecipesStatusComputerBase.DocExtractionRecipesStatus {
        RecipeStatus.StepStatus metadataDataset;

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = super.gatherAllMessages();
            if (this.metadataDataset != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.metadataDataset);
            }
            return ret;
        }
    }
}

