/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.evaluation.llm;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.nlp.evaluation.GenAIEvaluationRecipeParams;
import com.dataiku.dip.recipes.nlp.evaluation.GenAIEvaluationUtils;
import com.dataiku.dip.recipes.nlp.evaluation.llm.LLMEvaluationRecipeCreator;
import com.dataiku.dip.recipes.nlp.evaluation.llm.LLMEvaluationRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.evaluation.llm.LLMEvaluationRecipeRunner;
import com.dataiku.dip.recipes.nlp.evaluation.llm.LLMEvaluationRecipeSchemaComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LLMEvaluationRecipeMeta
extends RecipeMeta
implements MetaWithSelectableCodeEnv {
    public static final LLMEvaluationRecipeMeta META = new LLMEvaluationRecipeMeta();

    @Override
    public String getType() {
        return "nlp_llm_evaluation";
    }

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return GenAIEvaluationRecipeParams.class;
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new LLMEvaluationRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.RELIABLE_STATIC;
    }

    @Override
    public boolean hasJsonPayload() {
        return true;
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) throws Exception {
        return new LLMEvaluationRecipeRunner(activity);
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new LLMEvaluationRecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) throws Exception {
        return RecipeMeta.defaultStatusComputer("DSS", "DSS", "MEMORY", "In-memory", "DSS");
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        RecipeDesc desc = new RecipeDesc("LLM Evaluation", null);
        desc.inputRoles.add(RecipeDesc.IORoleDef.newUnaryRequiredDataset("main", "Evaluation Dataset"));
        desc.outputRoles.add(RecipeDesc.IORoleDef.newUnaryDataset("main", "Output Dataset"));
        desc.outputRoles.add(RecipeDesc.IORoleDef.newUnaryDataset("metrics", "Metrics"));
        RecipeDesc.IORoleDef llmEs = RecipeDesc.IORoleDef.newUnaryLLMEvaluationStore("evaluationStore", "LLM Evaluation Store");
        desc.outputRoles.add(llmEs);
        return desc;
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withNlp();
    }

    protected LLMEvaluationRecipePayloadParams loadPayload(String payload) {
        return (LLMEvaluationRecipePayloadParams)JSON.parse((String)payload, LLMEvaluationRecipePayloadParams.class);
    }

    @Override
    public Set<String> underlyingConnectionNames(SerializedRecipe serializedRecipe, String payload) {
        HashSet<String> ret = new HashSet<String>();
        LLMEvaluationRecipePayloadParams params = this.loadPayload(payload);
        GenAIEvaluationUtils.getLLMConnection(params.completionLLMId).ifPresent(ret::add);
        GenAIEvaluationUtils.getLLMConnection(params.embeddingLLMId).ifPresent(ret::add);
        return ret;
    }

    @Override
    public RecipePayloadParams remapConnections(SerializedRecipe serializedRecipe, String payload, Map<String, String> replacements) {
        LLMEvaluationRecipePayloadParams params = this.loadPayload(payload);
        params.completionLLMId = GenAIEvaluationUtils.remapConnectionOfLLMId(params.completionLLMId, replacements);
        params.embeddingLLMId = GenAIEvaluationUtils.remapConnectionOfLLMId(params.embeddingLLMId, replacements);
        return params;
    }

    @Override
    public CodeEnvModel.EnvLang getEnvLang() {
        return CodeEnvModel.EnvLang.PYTHON;
    }
}

