/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.shaker;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetSparkInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.FakeJobActivityFromRecipeBuilder;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.shaker.ShakerRecipeParams;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.ServiceUtils;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.mrimpl.formats.UniversalFileInputFormat;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.sql.AbstractSqlQueryWithSchemaBuilder;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.ShakerSQLTranslator;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ShakerRecipeStatusComputer
extends RecipeStatusComputer {
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private VisualSQLRecipesBaseService visualSQLRecipesBaseService;
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.shaker.status.computer");

    public ShakerRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        ShakerRecipeStatus status;
        ShakerRecipeStatusRequest req = (ShakerRecipeStatusRequest)JSON.parse((String)requestData, ShakerRecipeStatusRequest.class);
        if (req == null) {
            req = new ShakerRecipeStatusRequest();
        }
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(authCtx, init);
        }
        if (VisualSQLRecipeStatusComputer.needToComputeExecutionPlanBasedOnEngine(status.getSelectedEngineBase(), req.reallyNeedsExecutionPlan)) {
            ExecutionPlanService executionPlanService;
            ShakerRecipeParams params;
            if ("SQL".equals(status.getSelectedEngineBase().type) && StringUtils.isNotBlank((String)status.sql) && !status.usesSnowflakeUDF) {
                try {
                    ExecutionPlanService executionPlanService2 = (ExecutionPlanService)SpringUtils.getBean(ExecutionPlanService.class);
                    status.executionPlan = executionPlanService2.getSqlExecutionPlan(this.recipe, status.sql, authCtx).call();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                    logger.info((Object)("Query:\n" + status.sql));
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute execution plan: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
            if ("HIVE".equals(status.getSelectedEngineBase().type) && StringUtils.isNotBlank((String)status.sql)) {
                params = (ShakerRecipeParams)this.recipe.params;
                try {
                    executionPlanService = (ExecutionPlanService)SpringUtils.getBean(ExecutionPlanService.class);
                    status.executionPlan = executionPlanService.getHiveExecutionPlan(this.recipe, status.sql, authCtx, params.engineParams.hive);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                    logger.info((Object)("Query:\n" + status.sql));
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute execution plan: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
            if ("IMPALA".equals(status.getSelectedEngineBase().type) && StringUtils.isNotBlank((String)status.sql)) {
                params = (ShakerRecipeParams)this.recipe.params;
                try {
                    executionPlanService = (ExecutionPlanService)SpringUtils.getBean(ExecutionPlanService.class);
                    status.executionPlan = executionPlanService.getImpalaExecutionPlan(this.recipe, status.sql, authCtx, params.engineParams.impala);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                    logger.info((Object)("Query:\n" + status.sql));
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute execution plan: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
        }
        RecipeEngineStatus selectedEngineBase = status.getSelectedEngineBase();
        if (StringUtils.isNotBlank((String)status.sql) && selectedEngineBase.statusWarnLevel == RecipeEngineStatus.WarningLevel.OK) {
            Schema outputSchema = null;
            try {
                outputSchema = req.outputSchema;
            }
            catch (Exception e) {
                logger.warn((Object)"No output schema sent from frontend, can't check final casts");
            }
            if (outputSchema != null && !outputSchema.getColumns().isEmpty()) {
                for (SchemaColumn columnInOutput : outputSchema.getColumns()) {
                    if (StringUtils.isEmpty((String)columnInOutput.getName())) continue;
                    SchemaColumn columnInChain = init.sqb.getCurrentColumn(columnInOutput.getName());
                    if (columnInChain == null) {
                        logger.warn((Object)("Could not find column '" + columnInOutput.getName() + "' in query output"));
                        continue;
                    }
                    if (columnInChain.getType() != Type.STRING || !columnInOutput.getType().isTemporal() || init.sqb.getDialect() != null && init.sqb.getDialect().canCastDSSFormatToTemporal()) continue;
                    selectedEngineBase.statusWarnLevel = RecipeEngineStatus.WarningLevel.WARN;
                    selectedEngineBase.statusMessage = "Adding implicit cast from string to " + columnInOutput.getType().getName() + " for column '" + columnInOutput.getName() + "'. This might not be supported by the database";
                }
            }
        }
        return status;
    }

    public VisualSQLRecipeStatus getStatusForConversion_NT(AuthCtx authCtx) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            ShakerRecipeStatus shakerRecipeStatus = this.fastStatusIgnorePartitions(authCtx);
            return shakerRecipeStatus;
        }
    }

    @Override
    public ShakerRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(authCtx, new StatusInitializer());
    }

    private ShakerRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx, StatusInitializer init) throws Exception {
        ShakerRecipeStatus status;
        block57: {
            RecipeEngineStatus selectedEngineBase;
            status = new ShakerRecipeStatus();
            JobActivity activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
            ShakerRecipeParams params = (ShakerRecipeParams)this.recipe.params;
            status.engines = this.createEnginesStatus(authCtx, activity);
            status.selectedEngine = this.selectEngine(authCtx, activity, params.engineType, status.engines);
            logger.debug((Object)("Pre-selected engine: " + status.selectedEngine.type));
            this.performBasicStructureChecks(status, authCtx);
            this.performBasicCDEChecks(status, authCtx);
            this.recipesValidationService.checkTargetsAreWritable(activity);
            AnyLoc inputLoc = this.recipe.getInputsForRole("main").get(0).getLoc(this.recipe.projectKey);
            SerializedDataset mainInputDataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(inputLoc);
            init.mainInputDS = Dataset.fromSerialized(inputLoc.getFullName(), mainInputDataset);
            VisualSQLRecipesBaseService.SQLBasedEngineStatus sql = null;
            VisualSQLRecipesBaseService.SQLBasedEngineStatus hive = null;
            VisualSQLRecipesBaseService.SQLBasedEngineStatus impala = null;
            VisualSQLRecipesBaseService.SQLBasedEngineStatus spark = null;
            RecipeEngineStatus stream = null;
            for (RecipeEngineStatus engine : status.engines) {
                if (engine.type.equals("DSS")) {
                    stream = engine;
                }
                if (engine.type.equals("SQL")) {
                    sql = (VisualSQLRecipesBaseService.SQLBasedEngineStatus)engine;
                }
                if (engine.type.equals("HIVE")) {
                    hive = (VisualSQLRecipesBaseService.SQLBasedEngineStatus)engine;
                }
                if (engine.type.equals("IMPALA")) {
                    impala = (VisualSQLRecipesBaseService.SQLBasedEngineStatus)engine;
                }
                if (!engine.type.equals("SPARK")) continue;
                spark = (VisualSQLRecipesBaseService.SQLBasedEngineStatus)engine;
            }
            AbstractSQLConnection connForSQL = null;
            try {
                connForSQL = DatasetInspector.getDSSConnectionForSQLAbleDatasetOrHive(authCtx, init.mainInputDS);
            }
            catch (Exception engine) {
                // empty catch block
            }
            HiveConnection connForHive = new HiveConnection(null);
            ImpalaConnection connForImpala = new ImpalaConnection();
            SQLDialect dialectForSql = sql.isSelectable ? connForSQL.getDialect() : null;
            HiveSQLDialect dialectForHive = new HiveSQLDialect();
            ImpalaSQLDialect dialectForImpala = new ImpalaSQLDialect();
            SparkSQLDialect dialectForSpark = new SparkSQLDialect();
            H2SQLDialect dialectForStream = new H2SQLDialect();
            spark.label = "Spark";
            VariablesContext vc = this.variablesService.getForProject(this.recipe.getProjectKey());
            logger.info((Object)"Updating translatability");
            SerializedShakerScript rawSss = (SerializedShakerScript)JSON.parse((String)this.payload, SerializedShakerScript.class);
            SerializedShakerScript sss = rawSss.expandedDeepCopy(vc);
            List<ProcessorScriptStep> processors = AbstractSqlQueryWithSchemaBuilder.getFlattenedEnabledProcessorsList(sss);
            for (ProcessorScriptStep pss : processors) {
                ScriptStepTranslatability translatability = new ScriptStepTranslatability();
                ProcessorMeta<?, ?> meta = BaseProcessorsFactory.getMeta(pss);
                if (!pss.disabled) {
                    ProcessorMeta.ProcessorCapabilitiesSummary capabilities;
                    if (sql.isSelectable) {
                        capabilities = meta.getCapabilities(pss.params, pss.designTimeReport, dialectForSql, connForSQL, init.mainInputDS);
                        if (sql == status.getSelectedSQLBasedEngine()) {
                            if (capabilities.can(ProcessorCapabilities.SQL_TRANSLATABLE)) {
                                translatability.canSql();
                            } else {
                                translatability.cannotSql(capabilities.reasonForInability(ProcessorCapabilities.SQL_TRANSLATABLE));
                            }
                        }
                        if (!capabilities.can(ProcessorCapabilities.SQL_TRANSLATABLE) && sql.statusWarnLevel != RecipeEngineStatus.WarningLevel.ERROR) {
                            sql.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                            sql.statusMessage = "Not supported settings for '" + pss.type + "' processor";
                            if (StringUtils.isNotBlank((String)capabilities.reasonForInability(ProcessorCapabilities.SQL_TRANSLATABLE))) {
                                sql.statusMessage = sql.statusMessage + ": " + capabilities.reasonForInability(ProcessorCapabilities.SQL_TRANSLATABLE);
                            }
                        }
                    }
                    if (hive.isSelectable) {
                        capabilities = meta.getCapabilities(pss.params, pss.designTimeReport, dialectForHive, null, init.mainInputDS);
                        if (hive == status.getSelectedSQLBasedEngine()) {
                            if (capabilities.can(ProcessorCapabilities.SQL_TRANSLATABLE)) {
                                translatability.canSql();
                            } else {
                                translatability.cannotSql(capabilities.reasonForInability(ProcessorCapabilities.SQL_TRANSLATABLE));
                            }
                        }
                        if (!capabilities.can(ProcessorCapabilities.SQL_TRANSLATABLE) && hive.statusWarnLevel != RecipeEngineStatus.WarningLevel.ERROR) {
                            hive.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                            hive.statusMessage = "Not supported settings for '" + pss.type + "' processor";
                            if (StringUtils.isNotBlank((String)capabilities.reasonForInability(ProcessorCapabilities.SQL_TRANSLATABLE))) {
                                hive.statusMessage = hive.statusMessage + ": " + capabilities.reasonForInability(ProcessorCapabilities.SQL_TRANSLATABLE);
                            }
                        }
                    }
                    if (impala.isSelectable) {
                        capabilities = meta.getCapabilities(pss.params, pss.designTimeReport, dialectForImpala, null, init.mainInputDS);
                        if (impala == status.getSelectedSQLBasedEngine()) {
                            if (capabilities.can(ProcessorCapabilities.SQL_TRANSLATABLE)) {
                                translatability.canSql();
                            } else {
                                translatability.cannotSql(capabilities.reasonForInability(ProcessorCapabilities.SQL_TRANSLATABLE));
                            }
                        }
                        if (!capabilities.can(ProcessorCapabilities.SQL_TRANSLATABLE) && impala.statusWarnLevel != RecipeEngineStatus.WarningLevel.ERROR) {
                            impala.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                            impala.statusMessage = "Not supported settings for '" + pss.type + "' processor";
                            if (StringUtils.isNotBlank((String)capabilities.reasonForInability(ProcessorCapabilities.SQL_TRANSLATABLE))) {
                                impala.statusMessage = impala.statusMessage + ": " + capabilities.reasonForInability(ProcessorCapabilities.SQL_TRANSLATABLE);
                            }
                        }
                    }
                    if (spark.isSelectable) {
                        capabilities = meta.getCapabilities(pss.params, pss.designTimeReport, dialectForSpark, null, init.mainInputDS);
                        if (capabilities.can(ProcessorCapabilities.NO_SPARK_IMPL) && spark.statusWarnLevel != RecipeEngineStatus.WarningLevel.ERROR) {
                            spark.label = "Spark";
                            spark.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                            spark.statusMessage = "Processor " + pss.type + " is not available in Spark";
                        } else if (!params.engineParams.spark.useNativeProcessors) {
                            translatability.cannotNativeSpark("Optimized implementation disabled in recipe settings");
                            spark.label = "Spark";
                            spark.notOptimizedBecauseMessage = "Optimized implementation disabled in recipe settings";
                        } else if (!spark.useNativeProcessors) {
                            spark.label = "Spark";
                        } else {
                            if (spark == status.getSelectedSQLBasedEngine()) {
                                if (capabilities.can(ProcessorCapabilities.NATIVE_SPARK_IMPL)) {
                                    translatability.canNativeSpark();
                                } else {
                                    translatability.cannotNativeSpark(capabilities.reasonForInability(ProcessorCapabilities.NATIVE_SPARK_IMPL));
                                }
                            }
                            if (!capabilities.can(ProcessorCapabilities.NATIVE_SPARK_IMPL) && spark.statusWarnLevel != RecipeEngineStatus.WarningLevel.ERROR && spark.statusWarnLevel != RecipeEngineStatus.WarningLevel.ERROR) {
                                spark.label = "Spark (Regular)";
                                spark.notOptimizedBecauseMessage = "Not supported settings for '" + pss.type + "' processor";
                                if (StringUtils.isNotBlank((String)capabilities.reasonForInability(ProcessorCapabilities.NATIVE_SPARK_IMPL))) {
                                    spark.notOptimizedBecauseMessage = spark.notOptimizedBecauseMessage + ": " + capabilities.reasonForInability(ProcessorCapabilities.NATIVE_SPARK_IMPL);
                                }
                            }
                        }
                    }
                    if (stream.isSelectable && meta.getCapabilities(pss.params, pss.designTimeReport, dialectForStream).can(ProcessorCapabilities.NO_STREAM_IMPL)) {
                        stream.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                        stream.statusMessage = "Processor " + pss.type + " is not available in DSS engine";
                    }
                }
                status.translatabilities.add(translatability);
            }
            if (sql != null && sql.isSelectable && sql.statusWarnLevel != RecipeEngineStatus.WarningLevel.ERROR) {
                sql.recommended = true;
            }
            if (spark.isSelectable && "Spark (Optimized)".equals(spark.label) && !params.engineParams.spark.useNativeProcessors && spark.statusWarnLevel == RecipeEngineStatus.WarningLevel.OK) {
                spark.label = "Spark (Regular)";
                spark.notOptimizedBecauseMessage = "Optimized implementation disabled in recipe settings";
            }
            logger.debug((Object)("Before reselection, selectedEngine was " + ((selectedEngineBase = status.getSelectedEngineBase()) == null ? null : selectedEngineBase.type)));
            status.selectedEngine = this.selectEngine(authCtx, activity, params.engineType, status.engines);
            selectedEngineBase = status.getSelectedEngineBase();
            init.conn = null;
            init.dialectForQuery = null;
            if (sql == status.getSelectedSQLBasedEngine()) {
                init.conn = connForSQL;
                init.dialectForQuery = dialectForSql;
            } else if (hive == status.getSelectedSQLBasedEngine()) {
                init.conn = connForHive;
                init.dialectForQuery = dialectForHive;
            } else if (impala == status.getSelectedSQLBasedEngine()) {
                init.conn = connForImpala;
                init.dialectForQuery = dialectForImpala;
            }
            logger.info((Object)("After reselection, selectedEngine is " + selectedEngineBase.type));
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("SQL status " + JSON.json((Object)sql)));
            }
            if (sql.isSelectable && sql.statusWarnLevel == RecipeEngineStatus.WarningLevel.OK) {
                logger.debug((Object)"SQL is selectable");
                if (!ServiceUtils.canFullSQL(authCtx, activity, this.datasetsDAO).canUse()) {
                    logger.debug((Object)"Cannot Full SQL");
                    sql.label = "Partially in-database";
                    sql.variantLabel = "Prepare push-down, then streaming of results";
                    sql.description = "Prepare push-down, then streaming of results";
                } else {
                    logger.debug((Object)"Can Full SQL");
                }
            }
            if (selectedEngineBase.type.equals("SQL")) {
                status.topLevelMessages = status.topLevelMessages.withoutCode((InfoMessage.MessageCode)RecipeCodes.WARN_RECIPE_SLOW_WRITE_TO_REDSHIFT);
            }
            if (init.dialectForQuery != null && selectedEngineBase.statusWarnLevel != RecipeEngineStatus.WarningLevel.ERROR) {
                SerializedShakerScript rawSss2 = (SerializedShakerScript)JSON.parse((String)this.payload, SerializedShakerScript.class);
                SerializedShakerScript sss2 = rawSss2.expandedDeepCopy(vc);
                try {
                    SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(init.mainInputDS, init.dialectForQuery, null);
                    ShakerSQLTranslator.TranslatorResult translationResult = new ShakerSQLTranslator().translate(authCtx, this.recipe.projectKey, AbstractSqlQueryWithSchemaBuilder.getFlattenedEnabledProcessorsList(sss2), init.mainInputDS.getSchema(), table, init.conn, ShakerSQLTranslator.ShakerSQLTranslatorContext.RECIPE_STATUS_COMPUTE, init.mainInputDS, null, null);
                    init.sqb = translationResult.translated;
                    status.sql = init.sqb.toSQL(init.dialectForQuery);
                    status.usesSnowflakeUDF = translationResult.snowflakeUDFs.size() > 0;
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to generate SQL", (Throwable)e);
                    if (sql.isSelectable) {
                        sql.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                        sql.statusMessage = "Failed to generate SQL: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
                    }
                    if (hive.isSelectable) {
                        hive.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                        hive.statusMessage = "Failed to generate SQL: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
                    }
                    if (!impala.isSelectable) break block57;
                    impala.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                    impala.statusMessage = "Failed to generate SQL: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
                }
            }
        }
        return status;
    }

    private List<RecipeEngineStatus> createEnginesStatus(AuthCtx authCtx, JobActivity activity) throws Exception {
        AnyLoc inputLoc = this.recipe.getInputsForRole("main").get(0).getLoc(this.recipe.projectKey);
        AnyLoc outputLoc = this.recipe.getOutputsForRole("main").get(0).getLoc(this.recipe.projectKey);
        SerializedDataset mainInputDataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(inputLoc);
        SerializedDataset mainOutputDataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(outputLoc);
        Dataset outputDataset = this.getOutputDataset(activity);
        VisualSQLRecipesBaseService.AppConfig appConfig = this.visualSQLRecipesBaseService.getAppConfig(authCtx, this.recipe.projectKey);
        ArrayList<RecipeEngineStatus> ret = new ArrayList<RecipeEngineStatus>();
        RecipeEngineStatus stream = new RecipeEngineStatus("DSS", "DSS", "STREAM", "Stream", "DSS");
        stream.isSelectable = true;
        ret.add(stream);
        RecipeEngineStatus mr = new RecipeEngineStatus("HADOOP_MAPREDUCE", "Hadoop MapReduce", null, null, "Hadoop MapReduce");
        mr.canEngineAppend = false;
        if (!HadoopLoader.hadoopEnabled()) {
            mr.markAsNonSelectable("Hadoop not installed", RecipeEngineStatus.WarningLevel.ERROR);
        } else if (!DatasetInspector.canHDFS(mainInputDataset)) {
            mr.markAsNonSelectable("The input dataset " + mainInputDataset.getFullName() + " is not stored on HDFS", RecipeEngineStatus.WarningLevel.ERROR);
        } else if (UniversalFileInputFormat.getFormatAdapter(mainInputDataset.getFormatParams()) == null) {
            mr.markAsNonSelectable("The format of the input dataset " + mainInputDataset.getFullName() + " cannot be used on Hadoop (" + mainInputDataset.formatType + ")", RecipeEngineStatus.WarningLevel.ERROR);
        } else if (!DatasetInspector.canHDFS(mainOutputDataset)) {
            mr.markAsNonSelectable("The output dataset is not stored on HDFS", RecipeEngineStatus.WarningLevel.ERROR);
        } else {
            mr.isSelectable = true;
            mr.setStatus("(deprecated)", RecipeEngineStatus.WarningLevel.WARN);
        }
        ret.add(mr);
        VisualSQLRecipesBaseService.SQLBasedEngineStatus spark = this.visualSQLRecipesBaseService.makeSparkSQLEngineStatus(authCtx, this.recipe.projectKey, "SPARK_NATIVE", "Spark Native");
        ret.add(spark);
        VisualSQLRecipesBaseService.SQLBasedEngineStatus sql = this.visualSQLRecipesBaseService.makeSQLEngineStatus(authCtx, activity);
        ret.add(sql);
        VisualSQLRecipesBaseService.SQLBasedEngineStatus hive = this.visualSQLRecipesBaseService.makeHiveEngineStatus(authCtx, activity, appConfig);
        hive.recommended = false;
        ret.add(hive);
        VisualSQLRecipesBaseService.SQLBasedEngineStatus impala = this.visualSQLRecipesBaseService.makeImpalaEngineStatus(authCtx, activity, appConfig);
        ret.add(impala);
        if (this.recipe.redispatchPartitioning) {
            RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", spark, mr, sql);
        }
        return ret;
    }

    private Dataset getOutputDataset(JobActivity activity) throws IOException {
        List<FlowDataset> targetsDatasets = activity.getSubgraph().getTargetsDatasets();
        if (targetsDatasets == null || targetsDatasets.isEmpty()) {
            return null;
        }
        return targetsDatasets.get(0).getMandatory(this.datasetsDAO);
    }

    private RecipeEngineStatus selectEngine(AuthCtx authCtx, JobActivity activity, String userSelected, List<RecipeEngineStatus> statusList) throws IOException, DKUSecurityException {
        logger.info((Object)"Start select engine");
        RecipeEnginesPreferenceConfig resolvedPrefs = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, null);
        List<String> forbiddenEngines = resolvedPrefs.getEffectiveForbidden(this.recipe.type);
        for (String string : forbiddenEngines) {
            for (RecipeEngineStatus engine : statusList) {
                if (!engine.type.equals(string)) continue;
                engine.isSelectable = false;
                engine.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
                engine.statusMessage = "Forbidden by configuration";
            }
        }
        if (userSelected != null) {
            logger.info((Object)("User selected " + userSelected));
            return RecipeEngineStatus.getByType(statusList, userSelected);
        }
        List<String> userSpecifiedPreference = resolvedPrefs.getEffectivePreference(this.recipe.type);
        userSpecifiedPreference = RecipeStatus.filterToActualEngines(userSpecifiedPreference, RecipeStatus.toEngineTypes(statusList));
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Applicable user preference: " + JSON.json(userSpecifiedPreference)));
        }
        if (userSpecifiedPreference.size() > 0) {
            for (String type : userSpecifiedPreference) {
                RecipeEngineStatus res = RecipeStatus.getEngineByType(statusList, type);
                if (!res.isSelectable || res.statusWarnLevel != RecipeEngineStatus.WarningLevel.OK) continue;
                logger.info((Object)("Using user-preferred engine: " + type));
                return res;
            }
        }
        logger.trace((Object)"No user preference was usable, using heuristic");
        RecipeEngineStatus recipeEngineStatus = RecipeEngineStatus.getByType(statusList, "DSS");
        RecipeEngineStatus sql = RecipeEngineStatus.getByType(statusList, "SQL");
        RecipeEngineStatus spark = RecipeEngineStatus.getByType(statusList, "SPARK");
        logger.infoV("Engines OK: dss=%s sql=%s spark=%s", new Object[]{recipeEngineStatus.isOK(), sql.isOK(), spark.isOK()});
        if (sql.isOK() && ServiceUtils.canFullSQL(authCtx, activity, this.datasetsDAO).canUse() && this.areAllMainInputDatasetsRealSQL(activity)) {
            logger.info((Object)"Using possible SQL because full-SQL-able");
            return sql;
        }
        if (logger.isTraceEnabled()) {
            logger.traceV("Not using SQL because fullSQL=%s areAllInputDatasetsRealSQL=%s", new Object[]{ServiceUtils.canFullSQL(authCtx, activity, this.datasetsDAO).canUse(), this.areAllMainInputDatasetsRealSQL(activity)});
        }
        if (spark.isOK()) {
            DatasetSparkInspector.SparkFastPathStatus sparkFPS = ServiceUtils.canLikelySparkFastPathRead(authCtx, activity, this.datasetsDAO);
            logger.trace(() -> "Spark fast-path status: " + JSON.json((Object)sparkFPS));
            if (sparkFPS.ok) {
                logger.info((Object)"Using possible Spark because spark-fast-path-able");
                return spark;
            }
        }
        logger.trace((Object)"No engine selected by heuristic, taking what we can");
        if (recipeEngineStatus.isSelectable && recipeEngineStatus.statusWarnLevel == RecipeEngineStatus.WarningLevel.OK) {
            return recipeEngineStatus;
        }
        for (RecipeEngineStatus res : statusList) {
            if (!res.isSelectable || res.statusWarnLevel != RecipeEngineStatus.WarningLevel.OK) continue;
            return res;
        }
        return recipeEngineStatus;
    }

    public RecipeEngineStatus selectEngine(AuthCtx authCtx, String userSelected, JobActivity activity) throws Exception {
        ShakerRecipeStatus status = this.fastStatusIgnorePartitions(authCtx);
        return status.selectedEngine;
    }

    private boolean areAllMainInputDatasetsRealSQL(JobActivity activity) throws IOException {
        for (FlowComputable.FlowComputableWithRole computableWithRole : activity.getSubgraph().getSourcesWithRoles()) {
            FlowDataset fdsource;
            Dataset dataset;
            if (!(computableWithRole.computable instanceof FlowDataset) || computableWithRole.role != null && !computableWithRole.role.equals("main") || DatasetInspector.isSQL(dataset = (fdsource = (FlowDataset)computableWithRole.computable).getMandatory(this.datasetsDAO))) continue;
            return false;
        }
        return true;
    }

    static class ShakerRecipeStatusRequest {
        Schema outputSchema;
        boolean reallyNeedsExecutionPlan;

        ShakerRecipeStatusRequest() {
        }
    }

    public static class StatusInitializer {
        public Dataset mainInputDS;
        public AbstractSQLConnection conn;
        public SQLDialect dialectForQuery;
        public SQLQueryWithSchema sqb;
    }

    public static class ShakerRecipeStatus
    extends VisualSQLRecipeStatus {
        public List<ScriptStepTranslatability> translatabilities = Lists.newArrayList();

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            return ret;
        }
    }

    public static class ScriptStepTranslatability {
        public boolean checkedSql;
        public boolean canSql;
        public String sqlReason;
        public boolean checkedNativeSpark;
        public boolean canNativeSpark;
        public String nativeSparkReason;

        public void canSql() {
            this.checkedSql = true;
            this.canSql = true;
        }

        public void cannotSql(String reason) {
            this.checkedSql = true;
            this.canSql = false;
            this.sqlReason = reason;
        }

        public void canNativeSpark() {
            this.checkedNativeSpark = true;
            this.canNativeSpark = true;
        }

        public void cannotNativeSpark(String reason) {
            this.checkedNativeSpark = true;
            this.canNativeSpark = false;
            this.nativeSparkReason = reason;
        }
    }
}

