/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.scala;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.code.scala.CodeMode;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.streaming.scala.StreamingSparkScalaRecipeCreator;
import com.dataiku.dip.recipes.streaming.scala.StreamingSparkScalaRecipeStatusComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.spark.SparkOverrideConfig;

public class StreamingSparkScalaRecipeMeta
extends RecipeMeta {
    public static final StreamingSparkScalaRecipeMeta META = new StreamingSparkScalaRecipeMeta();

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return StreamingSparkScalaRecipeParams.class;
    }

    @Override
    public String getType() {
        return "streaming_spark_scala";
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new StreamingSparkScalaRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        throw new Error("this is a streaming recipe");
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return new StreamingSparkScalaRecipeStatusComputer(recipe, payload);
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        RecipeDesc ret = new RecipeDesc("Spark scala (Streaming)", null);
        ret.inputRoles.add(RecipeDesc.IORoleDef.newNary("main", ""));
        ret.outputRoles.add(RecipeDesc.IORoleDef.newUnaryRequiredDataset("main", ""));
        RecipeDesc.IORoleDef in = ret.inputRoles.get(0);
        in.acceptsStreamingEndpoint = true;
        RecipeDesc.IORoleDef out = ret.outputRoles.get(0);
        out.acceptsStreamingEndpoint = true;
        return ret;
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withUserCode().withSpark();
    }

    @Override
    public boolean hasJsonPayload() {
        return false;
    }

    @Override
    public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
        StreamingSparkScalaRecipeParams params = sr.getParamsAs(StreamingSparkScalaRecipeParams.class);
        return params.sparkConfig;
    }

    @Override
    public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
        StreamingSparkScalaRecipeParams params = sr.getParamsAs(StreamingSparkScalaRecipeParams.class);
        params.sparkConfig = config;
        return payload;
    }

    @Override
    public String setEngine(SerializedRecipe sr, String payload, String engine) {
        throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_CHANGE_ENGINE, "Cannot change engine for recipe type " + sr.type);
    }

    @Override
    public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
        StreamingSparkScalaRecipeParams params = sr.getParamsAs(StreamingSparkScalaRecipeParams.class);
        params.executionEngine = executionEngine;
        return payload;
    }

    public static class StreamingSparkScalaRecipeParams
    extends AbstractSparkRecipeParams {
        public boolean useGlobalMetastore = false;
        public CodeMode codeMode = CodeMode.FREE_FORM;
    }
}

