/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.runnables;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.AbstractImpersonableSecretProtectedPythonKernel;
import com.dataiku.dip.io.BasicKernelLink;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SocketBlockLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.scheduler.runnables.AbstractDSSRunnable;
import com.dataiku.dip.scheduler.runnables.DSSRunnable;
import com.dataiku.dip.scheduler.runnables.DSSRunnableResult;
import com.dataiku.dip.scheduler.runnables.DSSRunnableUtils;
import com.dataiku.dip.scheduler.runnables.ImpersonablePythonDSSRunnableKernel;
import com.dataiku.dip.scheduler.runnables.LoadedRunnable;
import com.dataiku.dip.scheduler.runnables.PythonRunnableDesc;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class AbstractPythonDSSRunnable
extends AbstractDSSRunnable<LoadedRunnable<PythonRunnableDesc>>
implements DSSRunnable {
    protected final AuthCtx authCtx;
    private AbstractImpersonableSecretProtectedPythonKernel<BasicKernelLink> kernel;
    private static Logger logger = Logger.getLogger((String)"dip.runnables.python.regular");

    public AbstractPythonDSSRunnable(AuthCtx authCtx, String projectKey, LoadedRunnable<PythonRunnableDesc> loaded) {
        super(projectKey, loaded);
        this.authCtx = authCtx;
    }

    protected abstract String getCode() throws IOException;

    protected abstract AbstractImpersonableSecretProtectedPythonKernel<BasicKernelLink> getKernel(BasicKernelLink var1, APITicketService.Ticket var2, File var3) throws IOException;

    protected abstract PluginSettingsResolver.ResolvedSettings getResolvedSettings() throws IOException, DKUSecurityException;

    @Override
    public SmartLogTail getLogTail() {
        return this.kernel == null ? null : this.kernel.getLogTail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DSSRunnableResult run(File contextDir, APITicketService.Ticket ticket) throws Exception {
        BasicKernelLink link = null;
        DSSRunnableResult commandResult = new DSSRunnableResult();
        try {
            String secret = SecretKeyGenerator.generate((int)16);
            PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
            link = new BasicKernelLink(secret, dssPortRange);
            try (AutoDelete tmpDir = FlowJobUtils.getTmpFolder("python-macro", "run-" + this.loaded.runnableType);){
                String code = this.getCode();
                this.kernel = this.getKernel(link, ticket, (File)tmpDir);
                this.kernel.start();
                PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.getResolvedSettings();
                ImpersonablePythonDSSRunnableKernel.PythonCommand command = new ImpersonablePythonDSSRunnableKernel.PythonCommand(this.projectKey, code, expandedPluginSettings.config, expandedPluginSettings.pluginConfig);
                link.sendRequest((Object)command);
                DSSRunnableUtils.waitEnd(this.projectKey, this.loaded, commandResult, this.kernel, link, contextDir);
            }
        }
        catch (SocketBlockLink.SecretKernelTimeoutException e) {
            logger.error((Object)"Failure during kernel startup", (Throwable)e);
            commandResult.logTail = this.kernel.getLogTail();
            commandResult.error = new WarningsContext.SerializedThrowable((Throwable)e);
            commandResult.type = null;
        }
        catch (SocketBlockLinkException e) {
            logger.error((Object)"Runnable closed connection abruptly", (Throwable)e);
            e.withLogTail(this.kernel);
            commandResult.logTail = e.getLogTail();
            commandResult.error = new WarningsContext.SerializedThrowable((Throwable)e);
            commandResult.type = null;
        }
        catch (Exception e) {
            logger.error((Object)"Failure during runnable", (Throwable)e);
            if (this.kernel != null) {
                commandResult.logTail = this.kernel.getLogTail();
            }
            commandResult.error = new WarningsContext.SerializedThrowable((Throwable)e);
            commandResult.type = null;
        }
        finally {
            if (this.kernel != null) {
                try {
                    this.kernel.killWithoutMercy();
                }
                catch (Throwable e) {
                    logger.error((Object)"Failed to kill kernel", e);
                }
            }
            if (link != null) {
                try {
                    link.close();
                }
                catch (Throwable e) {
                    logger.error((Object)"Failed to close link", e);
                }
            }
        }
        return commandResult;
    }
}

